/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Connector;
import net.argius.stew.Environment;
import net.argius.stew.Iteration;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.WindowOutputProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DatabaseInfoTree
extends JTree {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInfoTree.class);
    private Connector currentConnector;
    private DatabaseMetaData dbmeta;

    DatabaseInfoTree() {
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setScrollsOnExpand(true);
        this.setCellRenderer(new Renderer());
        this.setModel(new DefaultTreeModel(null));
        ActionUtility actionUtility = ActionUtility.getInstance(this);
        final DatabaseInfoTree databaseInfoTree = this;
        actionUtility.bindAction((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = DatabaseInfoTree.this.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>(treePathArray.length);
                for (TreePath treePath : treePathArray) {
                    InfoNode infoNode = (InfoNode)treePath.getLastPathComponent();
                    arrayList.add(infoNode.getNodeFullName());
                }
                String string = Iteration.join(arrayList, String.format("%n", new Object[0]));
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
            }
        }, "copy-full-name");
        actionUtility.bindAction(new AbstractAction("refresh"){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = DatabaseInfoTree.this.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                for (TreePath treePath : treePathArray) {
                    DatabaseInfoTree.this.refresh((InfoNode)treePath.getLastPathComponent());
                }
            }
        });
        actionUtility.bindAction(new AbstractAction("generate-where-phrase"){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = DatabaseInfoTree.this.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                ArrayList<ColumnNode> arrayList = new ArrayList<ColumnNode>();
                Set<String> set = DatabaseInfoTree.collectTableName(treePathArray, arrayList);
                if (set.isEmpty()) {
                    return;
                }
                DatabaseInfoTree.this.fireActionPerformed(DatabaseInfoTree.generateEquivalentJoinClause(arrayList));
            }
        });
        actionUtility.bindAction(new AbstractAction("generate-select-phrase"){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = DatabaseInfoTree.this.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                ArrayList<ColumnNode> arrayList = new ArrayList<ColumnNode>();
                Set<String> set = DatabaseInfoTree.collectTableName(treePathArray, arrayList);
                if (set.isEmpty()) {
                    return;
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                boolean bl = set.size() == 1;
                for (ColumnNode object2 : arrayList) {
                    arrayList2.add(bl ? object2.getName() : object2.getNodeFullName());
                }
                String string = arrayList2.isEmpty() ? "*" : Iteration.join(arrayList2, ", ");
                String string2 = Iteration.join(set, ", ");
                DatabaseInfoTree.this.fireActionPerformed(String.format("SELECT %s FROM %s WHERE ", string, string2));
            }
        });
        actionUtility.bindAction(new AbstractAction("generate-update-statement"){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = DatabaseInfoTree.this.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                ArrayList<ColumnNode> arrayList = new ArrayList<ColumnNode>();
                Set<String> set = DatabaseInfoTree.collectTableName(treePathArray, arrayList);
                if (set.isEmpty()) {
                    return;
                }
                if (set.size() != 1 || arrayList.isEmpty()) {
                    WindowOutputProcessor.showInformationMessageDialog(databaseInfoTree, Resource.getString("e.enables-select-just-1-table", new Object[0]), null);
                    return;
                }
                String string = set.toArray(new String[1])[0];
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (ColumnNode columnNode : arrayList) {
                    arrayList2.add(columnNode.getName() + "=?");
                }
                DatabaseInfoTree.this.fireActionPerformed(String.format("UPDATE %s SET %s WHERE ", string, Iteration.join(arrayList2, ", ")));
            }
        });
        actionUtility.bindAction(new AbstractAction("generate-insert-statement"){

            public void actionPerformed(ActionEvent actionEvent) {
                Iterable<TreeNode> iterable;
                TreePath[] treePathArray = DatabaseInfoTree.this.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                ArrayList<ColumnNode> arrayList = new ArrayList<ColumnNode>();
                Set<String> set = DatabaseInfoTree.collectTableName(treePathArray, arrayList);
                if (set.isEmpty()) {
                    return;
                }
                if (set.size() != 1) {
                    WindowOutputProcessor.showInformationMessageDialog(databaseInfoTree, Resource.getString("e.enables-select-just-1-table", new Object[0]), null);
                    return;
                }
                String string = set.toArray(new String[1])[0];
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (arrayList.isEmpty()) {
                    TreePath treePath = treePathArray[0];
                    TableNode infoNode = (TableNode)treePath.getLastPathComponent();
                    if (infoNode.getChildCount() == 0) {
                        DatabaseInfoTree.this.expandPath(treePath);
                    }
                    Iterable<TreeNode> iterable2 = Iteration.asIterable(infoNode.children());
                    iterable = iterable2;
                } else {
                    iterable = arrayList;
                }
                for (ColumnNode columnNode : iterable) {
                    arrayList2.add(columnNode.getName());
                }
                DatabaseInfoTree.this.fireActionPerformed(String.format("INSERT INTO %s (%s) VALUES (%s);", string, Iteration.join(arrayList2, ", "), Iteration.join(Collections.nCopies(arrayList2.size(), "?"), ", ")));
            }
        });
    }

    static Set<String> collectTableName(TreePath[] treePathArray, List<ColumnNode> list) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (TreePath treePath : treePathArray) {
            InfoNode infoNode;
            InfoNode infoNode2 = (InfoNode)treePath.getLastPathComponent();
            if (infoNode2 instanceof TableNode) {
                infoNode = (TableNode)infoNode2;
                if (!((TableNode)infoNode).isKindOfTable()) continue;
                linkedHashSet.add(((TableNode)infoNode).getNodeFullName());
                continue;
            }
            if (!(infoNode2 instanceof ColumnNode) || !((ColumnNode)(infoNode = (ColumnNode)infoNode2)).getTableNode().isKindOfTable()) continue;
            linkedHashSet.add(((ColumnNode)infoNode).getTableNode().getName());
            list.add((ColumnNode)infoNode);
        }
        return linkedHashSet;
    }

    void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    void fireActionPerformed(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    void refreshRoot(Environment environment) throws SQLException {
        Connector connector = environment.getCurrentConnector();
        if (connector == null) {
            if (log.isDebugEnabled()) {
                log.debug("not connected");
            }
            this.currentConnector = null;
            return;
        }
        if (connector == this.currentConnector) {
            if (log.isDebugEnabled()) {
                log.debug("not changed");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("updating");
        }
        ConnectorNode connectorNode = new ConnectorNode(connector.getName());
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(connectorNode);
        this.setModel(defaultTreeModel);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(4);
        this.setSelectionModel(defaultTreeSelectionModel);
        final DatabaseMetaData databaseMetaData = environment.getCurrentConnection().getMetaData();
        final HashSet<ConnectorNode> hashSet = new HashSet<ConnectorNode>();
        this.expandNode(connectorNode, databaseMetaData);
        hashSet.add(connectorNode);
        this.expandPath(new TreePath(connectorNode.getFirstChild()));
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreePath treePath = treeExpansionEvent.getPath();
                Object object = treePath.getLastPathComponent();
                if (!hashSet.contains(object)) {
                    InfoNode infoNode = (InfoNode)object;
                    hashSet.add(infoNode);
                    try {
                        DatabaseInfoTree.this.expandNode(infoNode, databaseMetaData);
                    }
                    catch (SQLException sQLException) {
                        throw new RuntimeException(sQLException);
                    }
                }
            }

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        this.dbmeta = databaseMetaData;
        defaultTreeModel.reload();
        this.setRootVisible(true);
        this.currentConnector = connector;
    }

    void refresh(InfoNode infoNode) {
        if (this.dbmeta == null) {
            return;
        }
        infoNode.removeAllChildren();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.reload(infoNode);
        try {
            this.expandNode(infoNode, this.dbmeta);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    void expandNode(InfoNode infoNode, DatabaseMetaData databaseMetaData) throws SQLException {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        for (InfoNode infoNode2 : infoNode.createChildren(databaseMetaData)) {
            defaultTreeModel.insertNodeInto(infoNode2, infoNode, infoNode.getChildCount());
        }
    }

    void clear() {
        for (TreeWillExpandListener treeWillExpandListener : (TreeWillExpandListener[])((TreeWillExpandListener[])this.getListeners(TreeWillExpandListener.class)).clone()) {
            this.removeTreeWillExpandListener(treeWillExpandListener);
        }
        this.setModel(null);
        this.currentConnector = null;
        this.dbmeta = null;
    }

    static String generateEquivalentJoinClause(List<ColumnNode> list) {
        if (list.isEmpty()) {
            return "";
        }
        ListMap listMap = new ListMap();
        ListMap listMap2 = new ListMap();
        for (ColumnNode object : list) {
            String string = object.getTableNode().getName();
            String string2 = object.getName();
            listMap.add(string, string2);
            listMap2.add(string2, String.format("%s.%s", string, string2));
        }
        ArrayList arrayList = new ArrayList();
        if (listMap.size() == 1) {
            for (ColumnNode columnNode : list) {
                arrayList.add(String.format("%s=?", columnNode.getName()));
            }
        } else {
            String string = list.get(0).getTableNode().getName();
            for (String string3 : (List)listMap.get(string)) {
                arrayList.add(String.format("%s.%s=?", string, string3));
            }
            for (Map.Entry entry : listMap2.entrySet()) {
                if (((String)entry.getKey()).equals(string) || ((List)entry.getValue()).size() != 1) continue;
                arrayList.add(String.format("%s=?", ((List)entry.getValue()).get(0)));
            }
            for (Map.Entry entry : listMap2.entrySet()) {
                Object[] objectArray = ((List)entry.getValue()).toArray();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    for (int j = i + 1; j < n; ++j) {
                        arrayList.add(String.format("%s=%s", objectArray[i], objectArray[j]));
                    }
                }
            }
        }
        return Iteration.join(arrayList, " AND ") + ';';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ColumnNode
    extends InfoNode {
        private String name;
        private TableNode tableNode;

        ColumnNode(String string, String string2, int n, String string3, TableNode tableNode) {
            super(ColumnNode.format(string, string2, n, string3));
            this.setAllowsChildren(false);
            this.name = string;
            this.tableNode = tableNode;
        }

        String getName() {
            return this.name;
        }

        TableNode getTableNode() {
            return this.tableNode;
        }

        private static String format(String string, String string2, int n, String string3) {
            String string4 = "NO".equals(string3) ? " NOT NULL" : "";
            return String.format("%s [%s(%d)%s]", string, string2, n, string4);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            return null;
        }

        @Override
        protected String getNodeFullName() {
            return String.format("%s.%s", this.tableNode.getName(), this.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TableNode
    extends InfoNode {
        private final String catalog;
        private final String schema;
        private final String name;
        private final boolean kindOfTable;

        TableNode(String string, String string2, String string3, boolean bl) {
            super(string3);
            this.catalog = string;
            this.schema = string2;
            this.name = string3;
            this.kindOfTable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>();
            ResultSet resultSet = databaseMetaData.getColumns(this.catalog, this.schema, this.name, null);
            try {
                while (resultSet.next()) {
                    arrayList.add(new ColumnNode(resultSet.getString(4), resultSet.getString(6), resultSet.getInt(7), resultSet.getString(18), this));
                }
            }
            finally {
                resultSet.close();
            }
            return arrayList;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        protected String getNodeFullName() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.catalog != null) {
                arrayList.add(this.catalog);
            }
            if (this.schema != null) {
                arrayList.add(this.schema);
            }
            arrayList.add(this.name);
            return Iteration.join(arrayList, ".");
        }

        String getName() {
            return this.name;
        }

        boolean isKindOfTable() {
            return this.kindOfTable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TableTypeNode
    extends InfoNode {
        private static final String ICON_NAME_FORMAT = "node-tabletype-%s.png";
        private final String catalog;
        private final String schema;
        private final String tableType;

        TableTypeNode(String string, String string2, String string3) {
            super(string3);
            this.catalog = string;
            this.schema = string2;
            this.tableType = string3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>();
            ResultSet resultSet = databaseMetaData.getTables(this.catalog, this.schema, null, new String[]{this.tableType});
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString(3);
                    String string2 = resultSet.getString(4);
                    boolean bl = string2.matches("TABLE|VIEW|SYNONIM");
                    arrayList.add(new TableNode(this.catalog, this.schema, string, bl));
                }
            }
            finally {
                resultSet.close();
            }
            return arrayList;
        }

        @Override
        String getIconName() {
            String string = String.format(ICON_NAME_FORMAT, this.getUserObject());
            if (this.getClass().getResource("icon/" + string) == null) {
                return String.format(ICON_NAME_FORMAT, "");
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasItems(DatabaseMetaData databaseMetaData) throws SQLException {
            ResultSet resultSet = databaseMetaData.getTables(this.catalog, this.schema, null, new String[]{this.tableType});
            try {
                boolean bl = resultSet.next();
                return bl;
            }
            finally {
                resultSet.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SchemaNode
    extends InfoNode {
        private final String catalog;
        private final String schema;

        SchemaNode(String string, String string2) {
            super(string2);
            this.catalog = string;
            this.schema = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>();
            ResultSet resultSet = databaseMetaData.getTableTypes();
            try {
                while (resultSet.next()) {
                    TableTypeNode tableTypeNode = new TableTypeNode(this.catalog, this.schema, resultSet.getString(1));
                    if (!tableTypeNode.hasItems(databaseMetaData)) continue;
                    arrayList.add(tableTypeNode);
                }
            }
            finally {
                resultSet.close();
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CatalogNode
    extends InfoNode {
        private final String name;

        CatalogNode(String string) {
            super(string);
            this.name = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>();
            if (databaseMetaData.supportsSchemasInDataManipulation()) {
                ResultSet resultSet = databaseMetaData.getSchemas();
                try {
                    while (resultSet.next()) {
                        arrayList.add(new SchemaNode(this.name, resultSet.getString(1)));
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            ResultSet resultSet = databaseMetaData.getTableTypes();
            try {
                while (resultSet.next()) {
                    TableTypeNode tableTypeNode = new TableTypeNode(this.name, null, resultSet.getString(1));
                    if (!tableTypeNode.hasItems(databaseMetaData)) continue;
                    arrayList.add(tableTypeNode);
                }
            }
            finally {
                resultSet.close();
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectorNode
    extends InfoNode {
        ConnectorNode(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>();
            if (databaseMetaData.supportsCatalogsInDataManipulation()) {
                ResultSet resultSet = databaseMetaData.getCatalogs();
                try {
                    while (resultSet.next()) {
                        arrayList.add(new CatalogNode(resultSet.getString(1)));
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            if (databaseMetaData.supportsSchemasInDataManipulation()) {
                ResultSet resultSet = databaseMetaData.getSchemas();
                try {
                    while (resultSet.next()) {
                        arrayList.add(new SchemaNode(null, resultSet.getString(1)));
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            ResultSet resultSet = databaseMetaData.getTableTypes();
            try {
                while (resultSet.next()) {
                    TableTypeNode tableTypeNode = new TableTypeNode(null, null, resultSet.getString(1));
                    if (!tableTypeNode.hasItems(databaseMetaData)) continue;
                    arrayList.add(tableTypeNode);
                }
            }
            finally {
                resultSet.close();
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class InfoNode
    extends DefaultMutableTreeNode {
        InfoNode(Object object) {
            super(object, true);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        protected abstract List<InfoNode> createChildren(DatabaseMetaData var1) throws SQLException;

        String getIconName() {
            String string = this.getClass().getName();
            String string2 = string.replaceFirst(".+?([^\\$]+)Node$", "$1");
            return "node-" + string2.toLowerCase() + ".png";
        }

        protected String getNodeFullName() {
            return String.valueOf(this.userObject);
        }
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof InfoNode) {
                this.setIcon(Resource.getImageIcon(((InfoNode)object).getIconName()));
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListMap
    extends LinkedHashMap<String, List<String>> {
        ListMap() {
        }

        void add(String string, String string2) {
            if (this.get(string) == null) {
                this.put(string, new ArrayList());
            }
            ((List)this.get(string)).add(string2);
        }
    }
}

