/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;

public final class Find
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Find.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, Parameter parameter) throws CommandException {
        int n = 2;
        if (parameter.isEmpty(n)) {
            throw new UsageException(this.getUsage());
        }
        String string = parameter.get(n++);
        String string2 = parameter.get(n++);
        String string3 = parameter.get(n++);
        String string4 = parameter.get(n++);
        String string5 = parameter.get(n++);
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string6 = this.editNamePattern(string);
            String[] stringArray = this.editTableType(string2);
            String string7 = this.editNamePattern(string3);
            String string8 = this.editNamePattern(string4);
            boolean bl = string5.equalsIgnoreCase("FULL");
            if (log.isDebugEnabled()) {
                log.debug("name   : " + string6);
                log.debug("types  : " + (stringArray == null ? null : Arrays.asList(stringArray)));
                log.debug("schema : " + string7);
                log.debug("catalog: " + string8);
                log.debug("full?  : " + bl);
            }
            ResultSet resultSet = databaseMetaData.getTables(string8, string7, string6, stringArray);
            try {
                ResultSetReference resultSetReference = new ResultSetReference(resultSet, parameter.asString());
                if (!bl) {
                    ColumnOrder columnOrder = resultSetReference.getOrder();
                    columnOrder.addOrder(3, this.getColumnName("name"));
                    columnOrder.addOrder(4, this.getColumnName("type"));
                    columnOrder.addOrder(2, this.getColumnName("schema"));
                    columnOrder.addOrder(1, this.getColumnName("catalog"));
                }
                this.output(resultSetReference);
                this.outputMessage("i.selected", resultSetReference.getRecordCount());
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    private String getColumnName(String string) {
        return this.getMessage("Find.label." + string, new Object[0]);
    }

    private String[] editTableType(String string) {
        if (string == null || string.trim().length() == 0 || string.equals("*")) {
            return null;
        }
        return string.toUpperCase().split(",");
    }

    private String editNamePattern(String string) throws SQLException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (string.equals("''") || string.equals("\"\"")) {
            return "";
        }
        String string2 = this.convertPattern(string);
        if (log.isDebugEnabled()) {
            log.debug("table-name-condition : " + string2);
        }
        return string2;
    }
}

