/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import net.argius.stew.ui.window.Resource;

final class ActionUtility {
    private final JComponent c;
    private final ActionMap amap;
    private final InputMap imap;

    private ActionUtility(JComponent jComponent) {
        this.c = jComponent;
        this.amap = jComponent.getActionMap();
        this.imap = jComponent.getInputMap();
    }

    static ActionUtility getInstance(JComponent jComponent) {
        return new ActionUtility(jComponent);
    }

    Object bindAction(Action action) {
        return this.bindAction(action, action.getValue("Name"), null);
    }

    Object bindAction(Action action, Object object) {
        return this.bindAction(action, object, null);
    }

    Object bindAction(Action action, KeyStroke keyStroke) {
        return this.bindAction(action, action.getValue("Name"), keyStroke);
    }

    Object bindAction(Action action, Object object, KeyStroke keyStroke) {
        this.amap.put(object, action);
        this.imap.put(keyStroke, object);
        return object;
    }

    JMenuItem copyActionTo(Object object, JMenuItem jMenuItem) {
        final JComponent jComponent = this.c;
        final Action action = this.amap.get(object);
        if (action != null) {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    actionEvent.setSource(jComponent);
                    action.actionPerformed(actionEvent);
                }
            });
        }
        for (KeyStroke keyStroke : this.imap.allKeys()) {
            Object object2 = this.imap.get(keyStroke);
            if (object2 == null || !object2.equals(object)) continue;
            jMenuItem.setAccelerator(keyStroke);
            break;
        }
        return jMenuItem;
    }

    void setContextMenu(String[] stringArray) {
        this.setContextMenu(stringArray, null);
    }

    void setContextMenu(String[] stringArray, char[] cArray) {
        this.c.setComponentPopupMenu(this.createPopupMenu(stringArray, cArray));
    }

    JPopupMenu createPopupMenu(String[] stringArray, char[] cArray) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        int n = -1;
        for (String string : stringArray) {
            ++n;
            if (string == null || string.length() == 0) {
                jPopupMenu.addSeparator();
                continue;
            }
            char c = cArray == null ? (char)' ' : cArray[n];
            JMenuItem jMenuItem = new JMenuItem(Resource.getString("Action." + string, Character.valueOf(c)));
            jMenuItem.setMnemonic(c);
            jPopupMenu.add(this.copyActionTo(string, jMenuItem));
        }
        return jPopupMenu;
    }

    UndoManager setUndoAction() {
        if (!(this.c instanceof JTextComponent)) {
            throw new IllegalComponentStateException(this.c.getClass().getName());
        }
        JTextComponent jTextComponent = (JTextComponent)this.c;
        final UndoManager undoManager = new UndoManager();
        jTextComponent.getDocument().addUndoableEditListener(undoManager);
        ActionMap actionMap = jTextComponent.getActionMap();
        InputMap inputMap = jTextComponent.getInputMap();
        int n = Resource.getMenuShortcutKeyMask();
        actionMap.put("undo", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(90, n), "undo");
        actionMap.put("redo", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (undoManager.canRedo()) {
                    undoManager.redo();
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(89, n), "redo");
        return undoManager;
    }

    static UndoManager setUndoAction(JTextComponent jTextComponent) {
        return new ActionUtility(jTextComponent).setUndoAction();
    }

    void setActionForTextComponent() {
        if (!(this.c instanceof JTextComponent)) {
            throw new IllegalComponentStateException(this.c.getClass().getName());
        }
        final JTextComponent jTextComponent = (JTextComponent)this.c;
        final UndoManager undoManager = this.setUndoAction();
        JPopupMenu jPopupMenu = new JPopupMenu();
        final HashMap<String, JMenuItem> hashMap = new HashMap<String, JMenuItem>();
        for (String string : new String[]{"undo", "redo", "", "cut-to-clipboard", "copy-to-clipboard", "paste-from-clipboard", "select-all"}) {
            if (string.length() == 0) {
                jPopupMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem(Resource.getString("Action." + string, new Object[0]));
            jPopupMenu.add(this.copyActionTo(string, jMenuItem));
            hashMap.put(string, jMenuItem);
        }
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ((JMenuItem)hashMap.get("undo")).setEnabled(undoManager.canUndo());
                ((JMenuItem)hashMap.get("redo")).setEnabled(undoManager.canRedo());
                boolean bl = jTextComponent.getSelectionEnd() > jTextComponent.getSelectionStart();
                ((JMenuItem)hashMap.get("cut-to-clipboard")).setEnabled(bl);
                ((JMenuItem)hashMap.get("copy-to-clipboard")).setEnabled(bl);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        jTextComponent.setComponentPopupMenu(jPopupMenu);
    }

    static void setActionForTextComponent(JTextComponent jTextComponent) {
        new ActionUtility(jTextComponent).setActionForTextComponent();
    }
}

