/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.command;

import static net.argius.stew.Iteration.join;

import java.io.*;
import java.sql.*;
import java.util.*;

import net.argius.logging.*;
import net.argius.stew.*;
import net.argius.stew.io.*;

/**
 * t@C̓eSQLɔfR}hB
 * 
 * [h́ASQLt@CsƁAf[^[hAp[^ŋʂB
 * f[^[hł́At@C`͊gqɂ莩IɑIB
 * @see Importer
 */
public class Load extends Command {

    private static final Logger log = LoggerFactory.getLogger(Load.class);

    @Override
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(getUsage());
        }
        // 
        int argsIndex = 2;
        final File file = resolvePath(parameter.get(argsIndex));
        if (log.isDebugEnabled()) {
            log.debug("file: " + file.getAbsolutePath());
        }
        try {
            // s
            if (parameter.isEmpty(3)) {
                loadSql(conn, file);
            } else {
                final String p2 = parameter.get(argsIndex++);
                final String p3 = parameter.get(argsIndex++);
                loadRecord(conn, file, p2, p3.equalsIgnoreCase("header"));
            }
        } catch (IOException ex) {
            throw new CommandException(ex);
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    /**
     * SQLt@CǂݍŎsB
     * @param conn RlNV
     * @param file SQLt@C
     * @throws IOException o̓G[ꍇ
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void loadSql(Connection conn, File file) throws IOException, SQLException {
        StringBuffer buffer = new StringBuffer();
        char[] chars = new char[1024];
        FileReader reader = new FileReader(file);
        try {
            for (int length; (length = reader.read(chars)) >= 0;) {
                buffer.append(chars, 0, length);
            }
        } finally {
            reader.close();
        }
        String sql = buffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + sql);
        }
        Statement stmt = conn.createStatement();
        try {
            if (isSelect(sql)) {
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    ResultSetReference ref = new ResultSetReference(rs);
                    output(ref);
                    outputMessage("i.selected", ref.getRecordCount());
                } finally {
                    rs.close();
                }
            } else {
                int count = stmt.executeUpdate(sql);
                outputMessage("i.proceeded", count);
            }
        } finally {
            stmt.close();
        }
    }

    /**
     * R[ht@CǂݍłꂼInsertB
     * rŃG[ꍇAIRollbackȂB
     * @param conn RlNV
     * @param file R[ht@C
     * @param tableName e[u
     * @param hasHeader wb_ꍇ <code>true</code>
     * @throws IOException o̓G[ꍇ
     * @throws SQLException SQL֘AG[ꍇ
     */
    protected void loadRecord(Connection conn,
                              File file,
                              String tableName,
                              boolean hasHeader) throws IOException, SQLException {
        Importer importer = Importer.getImporter(file);
        try {
            final Object[] header;
            if (hasHeader) {
                header = importer.nextRow();
            } else {
                // ŏ̍sŗ񐔂𔻒
                Importer importer2 = Importer.getImporter(file);
                try {
                    Object[] a = importer2.nextRow();
                    Arrays.fill(a, "");
                    header = a;
                } finally {
                    importer2.close();
                }
            }
            final List<Object> headerList = Arrays.asList(header);
            final String columns = (hasHeader) ? String.format("(%s)", join(headerList, ",")) : "";
            final List<Object> valueList = new ArrayList<Object>(headerList);
            Collections.fill(valueList, "?");
            final String sql = String.format("INSERT INTO %s %s VALUES (%s)",
                                             tableName,
                                             columns,
                                             join(valueList, ","));
            if (log.isDebugEnabled()) {
                log.debug("SQL : " + sql);
            }
            PreparedStatement stmt = conn.prepareStatement(sql);
            try {
                insertRecords(stmt, importer);
            } finally {
                stmt.close();
            }
        } finally {
            importer.close();
        }
    }

    /**
     * R[hInsertB
     * @param stmt PreparedStatement
     * @param importer Importer
     * @throws IOException o̓G[ꍇ
     * @throws SQLException SQL֘AG[ꍇ
     */
    protected void insertRecords(PreparedStatement stmt, Importer importer) throws IOException, SQLException {
        int recordCount = 0;
        int insertedCount = 0;
        int errorCount = 0;
        while (true) {
            Object[] row = importer.nextRow();
            if (row == null || row.length == 0) {
                break;
            }
            ++recordCount;
            try {
                for (int i = 0; i < row.length; i++) {
                    int index = i + 1;
                    Object o = row[i];
                    stmt.setObject(index, o);
                }
                insertedCount += stmt.executeUpdate();
            } catch (SQLException ex) {
                String message = "error occurred at " + recordCount;
                if (log.isTraceEnabled()) {
                    log.trace(message, ex);
                } else if (log.isDebugEnabled()) {
                    log.debug(message + " : " + ex);
                }
                ++errorCount;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("record   = " + recordCount);
            log.debug("inserted = " + insertedCount);
            log.debug("error    = " + errorCount);
        }
        outputMessage("i.loaded", insertedCount, recordCount);
    }

}