/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.io.*;
import java.sql.*;
import java.text.*;
import java.util.*;

import net.argius.stew.io.*;
import net.argius.stew.ui.*;

/**
 * R}h̊B
 */
public abstract class Command {

    // for "isSelect"
    private static final String SELECT = "SELECT";
    private static final int SELECT_LENGTH = SELECT.length();

    protected Environment env;
    protected OutputProcessor op;

    private final ResourceBundle resourceBundle;

    /**
     * RXgN^B
     */
    protected Command() {
        this.resourceBundle = ResourceBundle.getBundle(getClass().getPackage().getName()
                                                       + ".messages");
    }

    /**
     * B
     * @throws CommandException
     */
    public void initialize() throws CommandException {
        // empty
    }

    /**
     * R}hsB
     * @param conn RlNV
     * @param parameter p[^
     * @throws CommandException
     */
    public abstract void execute(Connection conn, Parameter parameter) throws CommandException;

    /**
     * R}hB
     * š㏈ȂǂsB
     * @throws CommandException
     */
    public void close() throws CommandException {
        // empty
    }

    /**
     * R}hNB
     * @param env s
     * @param parameterString p[^
     * @return 𑱍sꍇ <code>true</code>Afꍇ <code>false</code> 
     * @throws CommandException
     */
    public static boolean invoke(Environment env, String parameterString) throws CommandException {
        CommandProcessor processor = new CommandProcessor(env);
        return processor.invoke(parameterString);
    }

    /**
     * R}hǎpǂ𒲂ׂB
     * ǎp̃R}h́Ã\bhI[o[ChB
     * @return 
     */
    public boolean isReadOnly() {
        return false;
    }

    /**
     * ^CAEg̐ݒB
     * ݒl<code>0</code>ȏ̏ꍇ̂ݐݒ肳B
     * @param stmt Statement
     * @throws SQLException
     * @see Statement#setQueryTimeout(int)
     */
    protected void setTimeout(Statement stmt) throws SQLException {
        int timeoutSeconds = env.getTimeoutSeconds();
        if (timeoutSeconds >= 0) {
            stmt.setQueryTimeout(timeoutSeconds);
        }
    }

    /**
     * Environment̐ݒB
     * @param env Environment
     */
    public final void setEnvironment(Environment env) {
        this.env = env;
        this.op = env.getOutputProcessor();
    }

    /**
     * pXB
     * ΃pX̏ꍇAJgfBNg̑΃pXƂB
     * @param path
     * @return ꂽpX
     */
    protected final File resolvePath(String path) {
        return Path.resolve(env.getCurrentDirectory(), path);
    }

    /**
     * pXB
     * ΃pX̏ꍇAJgfBNg̑΃pXƂB
     * @param file
     * @return ꂽpX
     */
    protected final File resolvePath(File file) {
        return Path.resolve(env.getCurrentDirectory(), file);
    }

    /**
     * Cӂ̃IuWFNgo͂B
     * @param object IuWFNg
     * @throws CommandException
     */
    protected final void output(Object object) throws CommandException {
        op.output(object);
    }

    /**
     * bZ[Wo͂B
     * @param id bZ[WID
     * @param args MessageFormatɓn
     * @throws CommandException
     */
    protected final void outputMessage(String id, Object... args) throws CommandException {
        output(getMessage(id, args));
    }

    /**
     * bZ[W擾B
     * @param id bZ[WID
     * @param args MessageFormatɓn
     * @return bZ[W
     */
    protected final String getMessage(String id, Object... args) {
        try {
            final String s = resourceBundle.getString(id);
            if (args.length == 0) {
                return s;
            }
            return MessageFormat.format(s, args);
        } catch (MissingResourceException e) {
            return "?(" + id + Arrays.asList(args) + ')';
        }
    }

    /**
     * p^[̕ϊsB
     * f[^x[XɈˑ鎯ʎq̈lϊȂǂsB
     * @param pattern p^[
     * @return ϊꂽ
     * @throws SQLException
     */
    protected final String convertPattern(String pattern) throws SQLException {
        String edited;
        DatabaseMetaData dbmeta = env.getCurrentConnection().getMetaData();
        if (dbmeta.storesLowerCaseIdentifiers()) {
            edited = pattern.toLowerCase();
        } else if (dbmeta.storesUpperCaseIdentifiers()) {
            edited = pattern.toUpperCase();
        } else {
            edited = pattern;
        }
        return edited.replace('*', '%').replace('?', '_');
    }

    /**
     * USAGE擾B
     * @return USAGE
     */
    protected String getUsage() {
        final String name = getClass().getName().replaceFirst(".*\\.([^\\.]+)", "$1");
        return getMessage("usage." + name);
    }

    /**
     * SQLSELECTǂ𒲂ׂB
     * @param sql SQL
     * @return SELECTǂ
     */
    protected static boolean isSelect(String sql) {
        if (sql != null && sql.length() >= SELECT_LENGTH) {
            return SELECT.equalsIgnoreCase(sql.substring(0, SELECT_LENGTH));
        }
        // TODO SQLRg̔z
        return false;
    }

}
