/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.TextSearch;

final class TextSearchPanel
extends JPanel {
    private final List<TextSearch> targets = new ArrayList<TextSearch>();
    private final JTextField text = new JTextField(24);
    private final JCheckBox useRegexCheck = new JCheckBox(this.getMessage("useregex", new Object[0]));
    private final JCheckBox ignoreCaseCheck = new JCheckBox(this.getMessage("ignorecase", new Object[0]));
    private TextSearch currentTarget;
    private boolean searchBackward;

    TextSearchPanel(JFrame jFrame) {
        this.setLayout(new FlowLayout());
        this.setVisible(false);
        final JButton jButton = new JButton(Resource.getImageIcon("close.png"));
        JTextField jTextField = this.text;
        JButton jButton2 = new JButton(this.getMessage("forward", new Object[0]));
        JButton jButton3 = new JButton(this.getMessage("backward", new Object[0]));
        JCheckBox jCheckBox = this.useRegexCheck;
        final JCheckBox jCheckBox2 = this.ignoreCaseCheck;
        jButton.setToolTipText(this.getMessage("close", new Object[0]));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton2.setMargin(new Insets(0, 7, 0, 7));
        jButton3.setMargin(new Insets(0, 7, 0, 7));
        this.add(jButton);
        this.add(new JLabel("     "));
        this.add(new JLabel(this.getMessage("label", new Object[0])));
        this.add(jTextField);
        this.add(jButton2);
        this.add(jButton3);
        this.add(jCheckBox);
        this.add(jCheckBox2);
        final FocusTraversalPolicy focusTraversalPolicy = jFrame.getFocusTraversalPolicy();
        jFrame.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            public Component getComponentAfter(Container container, Component component) {
                if (component == jCheckBox2) {
                    return jButton;
                }
                return focusTraversalPolicy.getComponentAfter(container, component);
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == jButton) {
                    return jCheckBox2;
                }
                return focusTraversalPolicy.getComponentBefore(container, component);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextSearchPanel.this.setVisible(false);
            }
        };
        jButton.addActionListener(abstractAction);
        for (JComponent jComponent : new JComponent[]{jButton, jTextField, jButton2, jButton3, jCheckBox, jCheckBox2}) {
            ActionUtility.bindAction(jComponent, abstractAction, "close", KeyStroke.getKeyStroke(27, 0));
        }
        ActionUtility.bindAction(jTextField, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextSearchPanel.this.startSearch();
            }
        }, "search", KeyStroke.getKeyStroke(10, 0));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextSearchPanel.this.setSearchBackward(false);
                TextSearchPanel.this.startSearch();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextSearchPanel.this.setSearchBackward(true);
                TextSearchPanel.this.startSearch();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TextSearchPanel.this.validate();
            }
        });
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.text.requestFocus();
        } else {
            for (TextSearch textSearch : this.targets) {
                textSearch.reset();
            }
            if (this.currentTarget instanceof Component) {
                Component component = (Component)((Object)this.currentTarget);
                component.requestFocus();
            }
        }
    }

    void addTarget(TextSearch textSearch) {
        this.targets.add(textSearch);
    }

    void removeTarget(TextSearch textSearch) {
        this.targets.remove(textSearch);
    }

    void setCurrentTarget(TextSearch textSearch) {
        this.currentTarget = textSearch;
    }

    void setSearchBackward(boolean bl) {
        this.searchBackward = bl;
    }

    /*
     * WARNING - void declaration
     */
    void startSearch() {
        String string = this.text.getText();
        if (string == null || string.length() == 0 || this.currentTarget == null) {
            return;
        }
        boolean bl = this.useRegexCheck.isSelected();
        boolean bl2 = this.ignoreCaseCheck.isSelected();
        TextSearch.Matcher matcher = new TextSearch.Matcher(string, bl, bl2);
        matcher.setBackward(this.searchBackward);
        matcher.setContinuously(true);
        for (TextSearch object : this.targets) {
            object.reset();
        }
        boolean bl3 = this.currentTarget.search(matcher);
        if (!bl3) {
            void var6_10;
            if (this.currentTarget instanceof Component) {
                Container container = ((Component)((Object)this.currentTarget)).getParent();
            } else {
                Container container = this.getParent();
            }
            JOptionPane.showMessageDialog((Component)var6_10, this.getMessage("message.notfound", string), null, 2);
        }
    }

    private String getMessage(String string, Object ... objectArray) {
        return Resource.getString("TextSearchPanel." + string, objectArray);
    }
}

