/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.command;

import java.io.*;
import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * DownloadR}hB
 * w肵f[^t@CɕۑB
 */
public final class Download extends Command {

    private static final Logger log = LoggerFactory.getLogger(Download.class);

    @Override
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(getUsage());
        }
        final File file = new File(parameter.get(2));
        final String sql = parameter.getAll(3);
        if (log.isDebugEnabled()) {
            log.debug("file : " + file);
            log.debug("SQL : " + sql);
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                Statement stmt = conn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(sql);
                    if (!rs.next()) {
                        outputMessage("e.no-record");
                        return;
                    }
                    ResultSetMetaData meta = rs.getMetaData();
                    final int columnCount = meta.getColumnCount();
                    if (columnCount != 1) {
                        outputMessage("w.column-count-not-1");
                    }
                    final InputStream is;
                    switch (meta.getColumnType(1)) {
                        case Types.BLOB:
                        case Types.BINARY:
                        case Types.VARBINARY:
                        case Types.LONGVARBINARY:
                            // XXX ͖̔
                            is = rs.getBinaryStream(1);
                            break;
                        default:
                            is = rs.getAsciiStream(1);
                    }
                    try {
                        long transfered = 0L;
                        byte[] bytes = new byte[8192];
                        while (true) {
                            int read = is.read(bytes);
                            if (read <= 0) {
                                break;
                            }
                            fos.write(bytes, 0, read);
                            transfered += read;
                        }
                        outputMessage("i.downloaded", transfered / 1024f);
                    } finally {
                        is.close();
                    }
                    if (rs.next()) {
                        outputMessage("w.records-more-than-1");
                    }
                } finally {
                    stmt.close();
                }
            } finally {
                fos.close();
            }
        } catch (IOException ex) {
            throw new CommandException(ex);
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

}
