/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.sql.*;

/**
 * ResultSetQƁB
 */
public final class ResultSetReference {

    private final ResultSet rs;
    private final ColumnOrder order;

    private int recordCount;

    /**
     * ResultSetProcessor̐B
     * @param rs ResultSet
     */
    public ResultSetReference(ResultSet rs) {
        this.rs = rs;
        this.order = new ColumnOrder();
    }

    /**
     * ResultSet̎擾B
     * @return ResultSet
     */
    public ResultSet getResultSet() {
        return rs;
    }

    /**
     * 񏇏̎擾B
     * @return 񏇏
     */
    public ColumnOrder getOrder() {
        return order;
    }

    /**
     * ̎擾B
     * @return 
     */
    public int getRecordCount() {
        return recordCount;
    }

    /**
     * ̐ݒB
     * @param recordCount 
     */
    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

}