/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius;

import static net.argius.stew.PropertyKey.*;

import java.util.*;

import net.argius.stew.*;
import net.argius.stew.ui.*;
import net.argius.stew.ui.console.*;
import net.argius.stew.ui.window.*;

/**
 * 
 */
public final class Stew {

    /*
     * UIOărhꍇ
     * ̃NXB
     */

    private static final String GUI_MODE = "--gui";
    private static final String CUI_MODE = "--cui";
    private static final String EDIT_MODE = "--edit";

    /**
     * @param args
     */
    public static void main(String... args) {
        List<String> a = new ArrayList<String>(Arrays.asList(args));
        if (a.contains(GUI_MODE)) {
            a.remove(GUI_MODE);
            WindowLauncher.main(a.toArray(new String[a.size()]));
            return;
        } else if (a.contains(CUI_MODE)) {
            a.remove(CUI_MODE);
            ConsoleLauncher.main(a.toArray(new String[a.size()]));
            return;
        } else if (a.contains(EDIT_MODE)) {
            ConnectorMapEditor.main();
            return;
        }
        final String launcherName = LocalSystem.getProperty(LAUNCHER);
        final String outputName = LocalSystem.getProperty(OUTPUT_PROCESSOR);
        if (launcherName.length() > 0 && outputName.length() > 0) {
            Environment env = new Environment();
            try {
                Launcher launcher = DynamicLoader.newInstance(launcherName);
                env.setOutputProcessor(DynamicLoader.<OutputProcessor> newInstance(outputName));
                launcher.launch(env);
                return;
            } catch (DynamicLoadingException ex) {
                ex.printStackTrace();
            } finally {
                env.release();
            }
        }
        System.err.printf("usage: stew [%s|%s|%s]%n", GUI_MODE, CUI_MODE, EDIT_MODE);
    }

}
