/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

import static org.junit.Assert.*;

import java.io.*;
import java.lang.reflect.*;
import java.math.*;
import java.util.*;

import org.junit.*;

/**
 * 
 */
public class XmlImporterTest {

    private XmlImporter o;

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
        this.o = new XmlImporter(getClass().getResourceAsStream("XmlImporterTest.xml"));
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
        o.close();
    }

    /**
     * @throws IOException
     */
    @Test
    public void testXmlImporter() throws IOException {
        // getEncoding
        try {
            final String data = "<?xml version=\"1.0\" encoding=\"utf-8\"?>"
                                + "<!DOCTYPE table SYSTEM \"stew-table.dtd\">"
                                + "<table writer=\"net.argius.stew.io.XmlExporter\"></table>";
            Method m = XmlImporter.class.getDeclaredMethod("parseEncoding", String.class);
            m.setAccessible(true);
            assertEquals("utf-8", m.invoke(null, data));
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            final String data = "<?xml version=\"1.0\" encoding=\"shift_jis\"?>"
                                + "<!DOCTYPE table SYSTEM \"stew-table.dtd\">"
                                + "<table writer=\"net.argius.stew.io.XmlExporter\"></table>";
            Method m = XmlImporter.class.getDeclaredMethod("parseEncoding", String.class);
            m.setAccessible(true);
            assertEquals("shift_jis", m.invoke(null, data));
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            final String data = "<?xml version=\"1.0\"?>"
                                + "<!DOCTYPE table SYSTEM \"stew-table.dtd\">"
                                + "<table writer=\"net.argius.stew.io.XmlExporter\"></table>";
            Method m = XmlImporter.class.getDeclaredMethod("parseEncoding", String.class);
            m.setAccessible(true);
            assertEquals("utf-8", m.invoke(null, data));
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /***/
    @Test
    public void testGetHeader() {
        try {
            assertEquals("[ID, NAME, AGE, BIRTHDAY]", Arrays.toString(o.getHeader()));
            assertArrayEquals(new Object[0], o.getHeader());
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /***/
    @Test
    public void testReadHeader() {
        try {
            assertEquals("[ID, NAME, AGE, BIRTHDAY]", Arrays.toString(o.getHeader()));
            assertArrayEquals(new Object[0], o.getHeader());
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /***/
    @Test
    public void testNextRow() {
        try {
            assertEquals("[AAA, <, 3, null]", Arrays.toString(o.nextRow()));
            assertEquals("[BBB, , 24, Mon May 10 00:00:00 JST 2010]",
                         Arrays.toString(o.nextRow()));
            Object[] row = o.nextRow();
            assertEquals(1, row[0]);
            assertEquals(BigDecimal.valueOf(2.0d), row[1]);
            assertEquals(new HashMap<String, String>() {

                {
                    put("a", "#");
                }

            }, row[2]);
            assertArrayEquals(new Object[0], o.nextRow());
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /***/
    @Test
    public void testClose() {
        try {
            XmlImporter importer = new XmlImporter(new ByteArrayInputStream("".getBytes()));
            importer.close();
            importer.close();
        } catch (IOException ex) {
            assertEquals("stream closed", ex.getMessage());
        }
    }

}
