/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

import static org.junit.Assert.assertEquals;

import java.util.*;

import net.argius.stew.io.StringBasedSerializer.*;

import org.junit.*;


/**
 * 
 */
public class StringBasedSerializerTest {

    /**
     * @throws Exception
     */
    @Test
    public void testSerialize() throws Exception {
        HashMap<?, ?> m = new HashMap<Object, Object>();
        Element element = StringBasedSerializer.serialize(m);
        System.out.println(element);
    }

    /**
     * @throws Exception
     */
    @Test
    public void testDeserialize() throws Exception {
        HashMap<?, ?> m = new HashMap<Object, Object>();
        Element element = StringBasedSerializer.serialize(m);
        assertEquals(m, StringBasedSerializer.deserialize(element));
    }

}
