/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

import static org.junit.Assert.*;

import java.util.*;

import org.junit.*;


/**
 * 
 */
public class SmartImporterTest {

    private SmartImporter o;

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
        this.o = new SmartImporter(getClass().getResourceAsStream("SmartImporterTest.csv"), ",");
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
        o.close();
    }

    /**
     * {@link net.argius.stew.io.SmartImporter#SmartImporter(java.io.InputStream, java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testSmartImporter() {
        // empty
    }

    /**
     * {@link net.argius.stew.io.SmartImporter#nextRow()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testNextRow() {
        try {
            assertEquals("[aaa, bbb, ccc]", Arrays.toString(o.nextRow()));
            assertEquals("[123, ,, \n,]", Arrays.toString(o.nextRow()));
            assertEquals("[xxx, \"a]", Arrays.toString(o.nextRow()));
            assertArrayEquals(new Object[0], o.nextRow());
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /**
     * {@link net.argius.stew.io.SmartImporter#close()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testClose() {
        // empty
    }

}
