/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import static org.hamcrest.core.IsNot.not;
import static org.junit.Assert.*;

import java.util.*;

import org.junit.Test;

/**
 * 
 */
public class ConnectorMapTest {

    /**
     * {@link net.argius.stew.ConnectorMap#equals(java.lang.Object)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testEqualsObject() {
        Connector c = c("id1");
        System.out.println(c.toProperties());
        c.toProperties().setProperty("user", "xxx");
        System.out.println(c.toProperties());

        ConnectorMap m1 = new ConnectorMap();
        ConnectorMap m2 = new ConnectorMap();
        // 1
        Connector c1 = c("id1");
        m1.put(c1.getId(), c1);
        m2.put(c1.getId(), c1);
        assertEquals(m1, m2);
        assertTrue(m1.equals(m2));
        m2.put(c1.getId(), c1);
        assertEquals(m1, m2);
        assertTrue(m1.equals(m2));
        // 2
        Connector c2 = c("id2");
        m1.put(c2.getId(), c2);
        m2.put(c2.getId(), c2);
        assertEquals(m1, m2);
        assertTrue(m1.equals(m2));
        Connector c2a = c("id2a");
        m2.put(c2a.getId(), c2a);
        assertThat(m1, not(m2));
        m2.remove(c2a.getId());
        System.out.println("m1=" + m1);
        System.out.println("m2=" + m2);
        assertEquals(m1, m2);
        assertTrue(m1.equals(m2));
    }

    private static Connector c(String id) {
        Properties p = new Properties();
        p.setProperty("id", id);
        p.setProperty("user", id);
        return new Connector(id, p);
    }

}
