/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Environment;
import net.argius.stew.LocalSystem;
import net.argius.stew.ResultSetReference;
import net.argius.stew.io.Exporter;
import net.argius.stew.ui.OutputProcessor;
import net.argius.stew.ui.Prompt;
import net.argius.stew.ui.window.ConsoleTextArea;
import net.argius.stew.ui.window.Menu;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.ResultSetTableModel;
import net.argius.stew.ui.window.ValueTransporter;

final class WindowOutputProcessor
extends JFrame
implements OutputProcessor {
    private final Environment env;
    private final ResultSetTable resultSetTable;
    private final ConsoleTextArea textArea;
    private Menu.Item autoAdjustMode;
    private String currentCommand;
    private int lastSorted;

    WindowOutputProcessor(Environment environment, ResultSetTable resultSetTable, ConsoleTextArea consoleTextArea) {
        this.env = environment;
        this.resultSetTable = resultSetTable;
        this.textArea = consoleTextArea;
        this.lastSorted = -1;
    }

    public void output(Object object) {
        try {
            if (object instanceof ResultSet) {
                this.outputResult((ResultSet)object, new ColumnOrder());
                return;
            }
            if (object instanceof ResultSetReference) {
                ResultSetReference resultSetReference = (ResultSetReference)object;
                resultSetReference.setRecordCount(this.outputResult(resultSetReference.getResultSet(), resultSetReference.getOrder()));
                return;
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        final ConsoleTextArea consoleTextArea = this.textArea;
        if (object instanceof Prompt) {
            final String string = WindowOutputProcessor.replaceEOL(object.toString());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    consoleTextArea.append(string);
                    consoleTextArea.resetHomePosition();
                }
            });
        } else {
            final String string = WindowOutputProcessor.replaceEOL(String.format("%s%n", object));
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    consoleTextArea.append(string);
                }
            });
        }
    }

    public void close() {
        this.dispose();
    }

    String getCurrentCommand() {
        return this.currentCommand;
    }

    void setCurrentCommand(String string) {
        String string2 = this.currentCommand;
        this.currentCommand = string;
        this.firePropertyChange("currentCommand", string2, string);
    }

    Menu.Item getAutoAdjustMode() {
        return this.autoAdjustMode;
    }

    void setAutoAdjustMode(Menu.Item item) {
        Menu.Item item2 = this.autoAdjustMode;
        this.autoAdjustMode = item;
        this.firePropertyChange("autoAdjustMode", (Object)item2, (Object)item);
    }

    void changeTableColumnWidth(double d) {
        TableColumnModel tableColumnModel = this.resultSetTable.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth((int)((double)tableColumn.getWidth() * d));
        }
    }

    void adjustTableColumnWidth() {
        boolean bl;
        boolean bl2;
        if (this.autoAdjustMode == null) {
            return;
        }
        switch (this.autoAdjustMode) {
            case AUTO_ADJUST_MODE_HEADER: {
                bl2 = true;
                bl = false;
                break;
            }
            case AUTO_ADJUST_MODE_VALUE: {
                bl2 = false;
                bl = true;
                break;
            }
            case AUTO_ADJUST_MODE_HEADERANDVALUE: {
                bl2 = true;
                bl = true;
                break;
            }
            case AUTO_ADJUST_MODE_NONE: {
                bl2 = false;
                bl = false;
                break;
            }
            default: {
                throw new IllegalStateException("autoAdjustMode=" + (Object)((Object)this.autoAdjustMode));
            }
        }
        int n = this.resultSetTable.getRowCount();
        if (!bl2 && bl && n == 0) {
            return;
        }
        float f = (float)this.resultSetTable.getParent().getWidth() * 0.8f;
        TableColumnModel tableColumnModel = this.resultSetTable.getColumnModel();
        JTableHeader jTableHeader = this.resultSetTable.getTableHeader();
        int n2 = this.resultSetTable.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            TableCellRenderer tableCellRenderer;
            float f2 = 0.0f;
            if (bl2) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = jTableHeader.getDefaultRenderer();
                }
                if (tableCellRenderer != null) {
                    object = tableCellRenderer.getTableCellRendererComponent(this.resultSetTable, tableColumn.getHeaderValue(), false, false, 0, i);
                    f2 = (float)((Component)object).getPreferredSize().width * 1.5f;
                }
            }
            if (bl) {
                for (int j = 0; j < n; ++j) {
                    tableCellRenderer = this.resultSetTable.getCellRenderer(j, i);
                    if (tableCellRenderer == null) continue;
                    object = this.resultSetTable.getValueAt(j, i);
                    Component component = tableCellRenderer.getTableCellRendererComponent(this.resultSetTable, object, false, false, j, i);
                    if ((f2 = Math.max(f2, (float)component.getPreferredSize().width)) >= f) break;
                }
            }
            int n3 = Math.round(f2 > f ? f : f2) + 1;
            tableColumnModel.getColumn(i).setPreferredWidth(n3);
        }
    }

    int outputResult(ResultSet resultSet, ColumnOrder columnOrder) throws SQLException {
        int n;
        OutputProcessor outputProcessor = this.env.getOutputProcessor();
        final ResultSetTable resultSetTable = this.resultSetTable;
        final JTableHeader jTableHeader = resultSetTable.getTableHeader();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                resultSetTable.setVisible(false);
                jTableHeader.setVisible(false);
                ((DefaultTableModel)resultSetTable.getModel()).setRowCount(0);
            }
        });
        boolean bl = columnOrder.size() > 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = bl ? columnOrder.size() : resultSetMetaData.getColumnCount();
        Vector<String> vector = new Vector<String>(n2);
        if (bl) {
            for (n = 0; n < columnOrder.size(); ++n) {
                vector.add(columnOrder.getName(n));
            }
        } else {
            for (n = 1; n <= n2; ++n) {
                vector.add(resultSetMetaData.getColumnName(n));
            }
        }
        final ResultSetTableModel resultSetTableModel = new ResultSetTableModel(resultSet, vector.toArray(), this.currentCommand);
        Vector<Object> vector2 = new Vector<Object>(n2);
        ValueTransporter valueTransporter = ValueTransporter.getInstance("");
        final int n3 = LocalSystem.getPropertyAsInt("net.argius.stew.rowcount.limit", Integer.MAX_VALUE);
        int n4 = 0;
        while (resultSet.next()) {
            if (n4 >= n3) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        WindowOutputProcessor.this.output(Resource.getString("w.exceeded-limit", n3));
                    }
                });
                break;
            }
            ++n4;
            vector2.clear();
            for (int i = 0; i < n2; ++i) {
                int n5 = bl ? columnOrder.getOrder(i) : i + 1;
                vector2.add(valueTransporter.getObject(resultSet, n5));
            }
            resultSetTableModel.addRow((Vector)vector2.clone());
            if (this.env.getOutputProcessor() == outputProcessor) continue;
            throw new SQLException("interrupted");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                resultSetTable.setModel(resultSetTableModel);
                Container container = resultSetTable.getParent();
                if (container != null && container.getParent() instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)container.getParent();
                    ImageIcon imageIcon = Resource.getImageIcon(String.format("updatable-%s.png", resultSetTableModel.isUpdatable()));
                    jScrollPane.setCorner("UPPER_LEFT_CORNER", new JLabel(imageIcon, 0));
                }
                WindowOutputProcessor.this.adjustTableColumnWidth();
                jTableHeader.setVisible(true);
                resultSetTable.doLayout();
                resultSetTable.setVisible(true);
            }
        });
        return resultSetTableModel.getRowCount();
    }

    void sortTable(final int n) {
        int n2;
        if (this.lastSorted == n) {
            this.lastSorted = n2 = -1;
        } else {
            n2 = 1;
            this.lastSorted = n;
        }
        Vector<Vector> vector = ((DefaultTableModel)this.resultSetTable.getModel()).getDataVector();
        Collections.sort(vector, new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> list, List<Object> list2) {
                return this.c(list, list2) * n2;
            }

            private int c(List<Object> list, List<Object> list2) {
                if (list == null || list2 == null) {
                    return list == null ? (list2 == null ? 0 : -1) : 1;
                }
                Object object = list.get(n);
                Object object2 = list2.get(n);
                if (object == null || object2 == null) {
                    return object == null ? (object2 == null ? 0 : -1) : 1;
                }
                if (object instanceof Comparable) {
                    Comparable comparable = (Comparable)object;
                    Comparable comparable2 = (Comparable)object2;
                    return comparable.compareTo(comparable2);
                }
                return object.toString().compareTo(object2.toString());
            }
        });
        this.resultSetTable.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportTableContent() throws IOException {
        File file = this.env.getCurrentDirectory();
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(Resource.getString("dialog.export.title", new Object[0]));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.showSaveDialog(this.resultSetTable);
        File file2 = jFileChooser.getSelectedFile();
        if (file2 == null) {
            return;
        }
        if (file2.exists() && JOptionPane.showConfirmDialog(this.resultSetTable, Resource.getString("i.confirm-overwrite", file2), "", 0) != 0) {
            return;
        }
        Exporter exporter = Exporter.getExporter(file2);
        try {
            TableColumnModel tableColumnModel = this.resultSetTable.getTableHeader().getColumnModel();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object = tableColumnModel.getColumns();
            while (object.hasMoreElements()) {
                arrayList.add(object.nextElement().getHeaderValue());
            }
            exporter.addHeader(arrayList.toArray());
            object = (DefaultTableModel)this.resultSetTable.getModel();
            Vector<Vector> vector = ((DefaultTableModel)object).getDataVector();
            for (Vector vector2 : vector) {
                exporter.addRow(vector2.toArray());
            }
        }
        finally {
            exporter.close();
        }
        JOptionPane.showMessageDialog(this.resultSetTable, Resource.getString("i.exported", new Object[0]));
    }

    void showErrorDialog(Throwable throwable) {
        WindowOutputProcessor.showErrorDialog(this, throwable);
    }

    static void showErrorDialog(final Component component, Throwable throwable) {
        String string;
        JPanel jPanel = new JPanel(new BorderLayout());
        if (throwable == null) {
            string = Resource.getString(".error", "?");
            jPanel.add((Component)new JLabel(Resource.getString(".errornull", new Object[0])), "Center");
        } else {
            string = Resource.getString(".error", throwable.getClass().getName());
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            final String string2 = WindowOutputProcessor.replaceEOL(((Object)stringWriter).toString());
            JTextArea jTextArea = new JTextArea(throwable.getMessage(), 6, 60);
            jTextArea.setEditable(false);
            jTextArea.setWrapStyleWord(false);
            jTextArea.setLineWrap(true);
            jTextArea.setOpaque(false);
            jTextArea.setMargin(new Insets(4, 4, 4, 4));
            jPanel.add((Component)new JScrollPane(jTextArea), "Center");
            JPanel jPanel2 = new JPanel();
            jPanel.add((Component)jPanel2, "After");
            jPanel2.add(new JButton(new AbstractAction(Resource.getString("dialog.detail", new Object[0])){

                public void actionPerformed(ActionEvent actionEvent) {
                    JEditorPane jEditorPane = new JEditorPane("text/plain", string2);
                    jEditorPane.setCaretPosition(0);
                    jEditorPane.setEditable(false);
                    JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                    JOptionPane jOptionPane = new JOptionPane(jScrollPane, -1, -1);
                    JDialog jDialog = jOptionPane.createDialog(component, "");
                    jDialog.setResizable(true);
                    Dimension dimension = component.getSize();
                    dimension.width = (int)((double)dimension.width * 1.5);
                    dimension.height = (int)((double)dimension.height * 0.9);
                    jDialog.setSize(dimension);
                    jDialog.setLocationRelativeTo(component);
                    jDialog.setVisible(true);
                }
            }));
        }
        JOptionPane.showMessageDialog(component, jPanel, string, 0);
    }

    private static String replaceEOL(String string) {
        return string.replaceAll("\\\r\\\n?", "\n");
    }

    static final class Bypass
    implements OutputProcessor {
        private OutputProcessor op;
        private volatile boolean closed;

        Bypass(OutputProcessor outputProcessor) {
            this.op = outputProcessor;
        }

        public void output(Object object) {
            if (!this.closed) {
                this.op.output(object);
            }
        }

        public void close() {
            this.closed = true;
        }
    }
}

