/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Connector;
import net.argius.stew.Environment;
import net.argius.stew.Iteration;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.Resource;

final class DatabaseInfoTree
extends JTree {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInfoTree.class);
    private Connector currentConnector;

    DatabaseInfoTree() {
        this.setRootVisible(false);
        this.setVisible(false);
        this.setShowsRootHandles(true);
        this.setScrollsOnExpand(true);
        this.setCellRenderer(new Renderer());
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(4);
        this.setSelectionModel(defaultTreeSelectionModel);
    }

    void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    void fireActionPerformed(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    void refreshRoot(Environment environment) throws SQLException {
        Connector connector = environment.getCurrentConnector();
        if (connector == null) {
            if (log.isDebugEnabled()) {
                log.debug("not connected");
            }
            this.currentConnector = null;
            return;
        }
        if (connector == this.currentConnector) {
            if (log.isDebugEnabled()) {
                log.debug("not changed");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("updating");
        }
        final DatabaseMetaData databaseMetaData = environment.getCurrentConnection().getMetaData();
        ConnectorNode connectorNode = new ConnectorNode(connector.getName());
        connectorNode.initialize(databaseMetaData);
        final DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.setRoot(connectorNode);
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreePath treePath = treeExpansionEvent.getPath();
                Object object = treePath.getLastPathComponent();
                if (object instanceof BaseNode) {
                    BaseNode baseNode = (BaseNode)object;
                    try {
                        baseNode.initialize(databaseMetaData);
                    }
                    catch (SQLException sQLException) {
                        throw new RuntimeException(sQLException);
                    }
                }
                defaultTreeModel.reload();
            }

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        ActionUtility actionUtility = new ActionUtility(this);
        actionUtility.bindAction(new AbstractAction("copy"){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = DatabaseInfoTree.this.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                String string = Iteration.join(Iteration.map(Arrays.asList(treePathArray), new Iteration.Correspondence<TreePath, Object>(){

                    @Override
                    public Object f(TreePath treePath) {
                        return treePath.getLastPathComponent();
                    }
                }), System.getProperty("line.separator"));
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
            }
        }, "copy");
        actionUtility.setContextMenu_(new String[]{"copy"});
        defaultTreeModel.reload();
        this.setRootVisible(true);
        this.setVisible(true);
        this.currentConnector = connector;
    }

    private static final class ColumnNode
    extends BaseNode {
        ColumnNode(String string) {
            super(string);
        }

        public boolean isLeaf() {
            return false;
        }
    }

    private static final class TableNode
    extends BaseNode {
        private final String catalog;
        private final String schema;
        private final String name;

        TableNode(String string, String string2, String string3) {
            super(string3);
            this.catalog = string;
            this.schema = string2;
            this.name = string3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ResultSet resultSet = databaseMetaData.getColumns(this.catalog, this.schema, this.name, null);
            try {
                while (resultSet.next()) {
                    String string = "NO".equals(resultSet.getString(18)) ? "NOT NULL" : "";
                    String string2 = String.format("%s [%s(%d) %s]", resultSet.getString(4), resultSet.getString(6), resultSet.getInt(7), string);
                    this.add(new ColumnNode(string2));
                }
            }
            finally {
                resultSet.close();
            }
        }

        public boolean isLeaf() {
            return false;
        }
    }

    private static final class TableTypeNode
    extends BaseNode {
        private final String catalog;
        private final String schema;
        private final String tableType;

        TableTypeNode(String string, String string2, String string3) {
            super(string3);
            this.catalog = string;
            this.schema = string2;
            this.tableType = string3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ResultSet resultSet = databaseMetaData.getTables(this.catalog, this.schema, null, new String[]{this.tableType});
            try {
                while (resultSet.next()) {
                    this.add(new TableNode(this.catalog, this.schema, resultSet.getString(3)));
                }
            }
            finally {
                resultSet.close();
            }
        }
    }

    private static final class SchemaNode
    extends BaseNode {
        private final String catalog;
        private final String schema;

        SchemaNode(String string, String string2) {
            super(string2);
            this.catalog = string;
            this.schema = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ResultSet resultSet = databaseMetaData.getTableTypes();
            try {
                while (resultSet.next()) {
                    this.add(new TableTypeNode(this.catalog, this.schema, resultSet.getString(1)));
                }
            }
            finally {
                resultSet.close();
            }
        }
    }

    private static final class CatalogNode
    extends BaseNode {
        private final String name;

        CatalogNode(String string) {
            super(string);
            this.name = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            if (databaseMetaData.supportsSchemasInDataManipulation()) {
                ResultSet resultSet = databaseMetaData.getSchemas();
                try {
                    while (resultSet.next()) {
                        this.add(new SchemaNode(this.name, resultSet.getString(1)));
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            ResultSet resultSet = databaseMetaData.getTableTypes();
            try {
                while (resultSet.next()) {
                    this.add(new TableTypeNode(this.name, null, resultSet.getString(1)));
                }
            }
            finally {
                resultSet.close();
            }
        }
    }

    private static class ConnectorNode
    extends BaseNode {
        ConnectorNode(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            if (databaseMetaData.supportsCatalogsInDataManipulation()) {
                ResultSet resultSet = databaseMetaData.getCatalogs();
                try {
                    while (resultSet.next()) {
                        this.add(new CatalogNode(resultSet.getString(1)));
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            if (databaseMetaData.supportsSchemasInDataManipulation()) {
                ResultSet resultSet = databaseMetaData.getSchemas();
                try {
                    while (resultSet.next()) {
                        this.add(new SchemaNode(null, resultSet.getString(1)));
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            ResultSet resultSet = databaseMetaData.getTableTypes();
            try {
                while (resultSet.next()) {
                    this.add(new TableTypeNode(null, null, resultSet.getString(1)));
                }
            }
            finally {
                resultSet.close();
            }
        }
    }

    private static class BaseNode
    extends DefaultMutableTreeNode {
        protected boolean added;

        BaseNode(Object object) {
            super(object, true);
        }

        public boolean isLeaf() {
            return false;
        }

        final void reset() {
            this.removeAllChildren();
            this.added = false;
        }

        final void initialize(DatabaseMetaData databaseMetaData) throws SQLException {
            if (this.added) {
                return;
            }
            this.setChildren(databaseMetaData);
            this.added = true;
        }

        final String getIconName() {
            String string = this.getClass().getName();
            String string2 = string.replaceFirst(".+?([^\\$]+)Node$", "$1");
            return "node-" + string2.toLowerCase() + ".png";
        }

        protected void setChildren(DatabaseMetaData databaseMetaData) throws SQLException {
        }

        protected String getNodeFullName() {
            return "";
        }
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof BaseNode) {
                this.setIcon(Resource.getImageIcon(((BaseNode)object).getIconName()));
            }
            return this;
        }
    }
}

