/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.argius.stew.Connector;
import net.argius.stew.LocalSystem;
import net.argius.stew.Password;
import net.argius.stew.PbePassword;
import net.argius.stew.PlainTextPassword;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.ClassFinder;
import net.argius.stew.ui.window.FlexiblePanel;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class ConnectorEditDialog
extends JDialog {
    private static final int TEXT_SIZE = 32;
    private static final Color COLOR_ESSENTIAL = new Color(0xFFF099);
    private static File currentDirectory = new File(".");
    private final JTextField tId;
    private final JTextField tName;
    private final JTextField tDriver;
    private final JTextField tClasspath;
    private final JTextField tUrl;
    private final JTextField tUser;
    private final JPasswordField tPassword;
    private final JComboBox cPasswordClass;
    private final JCheckBox cReadOnly;
    private final JCheckBox cUsesAutoRollback;
    private List<ChangeListener> listenerList = new ArrayList<ChangeListener>();

    ConnectorEditDialog(JDialog jDialog, Connector connector) {
        super(jDialog);
        this.setTitle(ConnectorEditDialog.getMessage("title"));
        this.setDefaultCloseOperation(0);
        FlexiblePanel flexiblePanel = new FlexiblePanel();
        this.add(flexiblePanel);
        String string = connector.getId();
        this.tId = this.createJTextField(string, true);
        flexiblePanel.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.id")), false);
        flexiblePanel.addComponent(this.tId, true);
        this.tName = this.createJTextField(connector.getName(), false);
        flexiblePanel.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.name")), false);
        flexiblePanel.addComponent(this.tName, true);
        this.tClasspath = this.createJTextField(connector.getClasspath(), false);
        flexiblePanel.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.classpath")), false);
        flexiblePanel.addComponent(this.tClasspath, false);
        flexiblePanel.addComponent(new JButton(new AbstractAction(ConnectorEditDialog.getMessage("button.search.file")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.chooseClasspath();
            }
        }), true);
        this.tDriver = this.createJTextField(connector.getDriver(), true);
        flexiblePanel.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.driver")), false);
        flexiblePanel.addComponent(this.tDriver, false);
        flexiblePanel.addComponent(new JButton(new AbstractAction(ConnectorEditDialog.getMessage("button.search.driver")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.chooseDriverClass();
            }
        }), true);
        this.tUrl = this.createJTextField(connector.getUrl(), true);
        flexiblePanel.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.url")), false);
        flexiblePanel.addComponent(this.tUrl, true);
        this.tUser = this.createJTextField(connector.getUser(), true);
        flexiblePanel.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.user")), false);
        flexiblePanel.addComponent(this.tUser, true);
        this.tPassword = new JPasswordField(32);
        this.tPassword.setBackground(COLOR_ESSENTIAL);
        Password password = connector.getPassword();
        if (string.length() > 0 && password.hasPassword()) {
            this.tPassword.setText(password.getRowString());
        }
        flexiblePanel.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.password")), false);
        flexiblePanel.addComponent(this.tPassword, true);
        PasswordItem[] passwordItemArray = new PasswordItem[]{new PasswordItem(PlainTextPassword.class), new PasswordItem(PbePassword.class)};
        this.cPasswordClass = new JComboBox<PasswordItem>(passwordItemArray);
        this.cPasswordClass.setEditable(true);
        for (int i = 0; i < passwordItemArray.length; ++i) {
            if (passwordItemArray[i].getPasswordClass() != password.getClass()) continue;
            this.cPasswordClass.setSelectedIndex(i);
            break;
        }
        flexiblePanel.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.encryption")), false);
        flexiblePanel.addComponent(this.cPasswordClass, true);
        this.cReadOnly = new JCheckBox(ConnectorEditDialog.getMessage("connector.readonly"), connector.isReadOnly());
        flexiblePanel.addComponent(this.cReadOnly, true);
        this.cUsesAutoRollback = new JCheckBox(ConnectorEditDialog.getMessage("connector.autorollback"), connector.usesAutoRollback());
        flexiblePanel.addComponent(this.cUsesAutoRollback, true);
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 16, 0));
        jPanel.add(new JButton(new AbstractAction(ConnectorEditDialog.getMessage("button.register")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.requestClose(true);
            }
        }));
        jPanel.add(new JButton(new AbstractAction(ConnectorEditDialog.getMessage("button.try.connect")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.tryToConnect();
            }
        }));
        jPanel.add(new JButton(new AbstractAction(ConnectorEditDialog.getMessage("button.cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.requestClose(false);
            }
        }));
        flexiblePanel.c.gridwidth = 0;
        flexiblePanel.c.insets = new Insets(12, 0, 12, 0);
        flexiblePanel.c.anchor = 10;
        flexiblePanel.addComponent(jPanel, false);
        this.pack();
        this.getRootPane().getActionMap().put("cancel-and-close", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.requestClose(false);
            }
        });
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel-and-close");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConnectorEditDialog.this.requestClose(false);
            }
        });
    }

    private JTextField createJTextField(String string, boolean bl) {
        JTextField jTextField = new JTextField(32);
        if (string != null) {
            jTextField.setText(string);
            jTextField.setCaretPosition(0);
        }
        if (bl) {
            jTextField.setBackground(COLOR_ESSENTIAL);
        }
        new ActionUtility(jTextField).setActionForTextComponent();
        return jTextField;
    }

    void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(changeListener);
    }

    private Connector createConnector() {
        Object object;
        String string = this.tId.getText();
        Properties properties = new Properties();
        properties.setProperty("name", this.tName.getText());
        properties.setProperty("driver", this.tDriver.getText());
        properties.setProperty("classpath", this.tClasspath.getText());
        properties.setProperty("url", this.tUrl.getText());
        properties.setProperty("user", this.tUser.getText());
        properties.setProperty("readonly", Boolean.toString(this.cReadOnly.isSelected()));
        properties.setProperty("rollback", Boolean.toString(this.cUsesAutoRollback.isSelected()));
        Object object2 = this.cPasswordClass.getSelectedItem();
        if (object2 != null && object2 instanceof PasswordItem && !((PasswordItem)(object = (PasswordItem)object2)).getPasswordClass().equals(PlainTextPassword.class)) {
            properties.setProperty("password.class", ((PasswordItem)object).getName());
        }
        object = new Connector(string, properties);
        ((Connector)object).getPassword().setRowString(String.valueOf(this.tPassword.getPassword()));
        return object;
    }

    void chooseClasspath() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(currentDirectory);
        jFileChooser.setDialogTitle(ConnectorEditDialog.getMessage("dialog.search.file.header"));
        jFileChooser.setApproveButtonText(ConnectorEditDialog.getMessage("dialog.search.file.button"));
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.showDialog(this, null);
        File file = jFileChooser.getSelectedFile();
        if (file != null) {
            this.tClasspath.setText(file.getPath());
            currentDirectory = file.getParentFile();
        }
    }

    void chooseDriverClass() {
        Object object;
        String string = this.tClasspath.getText();
        if (string.length() > 0) {
            object = ConnectorEditDialog.getMessage("confirm.searchsystemclasspath");
            if (JOptionPane.showConfirmDialog(this, object, null, 2) != 0) {
                return;
            }
            string = LocalSystem.getProperty("java.class.path");
        }
        object = new LinkedHashSet();
        for (String string2 : string.split(File.pathSeparator)) {
            URL[] uRLArray;
            File file = new File(string2);
            try {
                uRLArray = new URL[]{file.toURL()};
            }
            catch (MalformedURLException malformedURLException) {
                continue;
            }
            ClassFinder malformedURLException = new ClassFinder(string2, (Set)object){
                final /* synthetic */ Set val$classes;
                {
                    this.val$classes = set;
                    super(string);
                }

                @Override
                public void filter(Class<?> clazz) {
                    if (Driver.class.isAssignableFrom(clazz)) {
                        this.val$classes.add(clazz.getName());
                    }
                }
            };
            URLClassLoader uRLClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() {
                    return new URLClassLoader(uRLArray);
                }
            });
            malformedURLException.setClassLoader(uRLClassLoader);
            malformedURLException.setFailMode(true);
            malformedURLException.find(file);
        }
        if (object.isEmpty()) {
            JOptionPane.showMessageDialog(this, ConnectorEditDialog.getMessage("search.driver.classnotfound"), null, 0);
        } else {
            Object[] objectArray;
            String string3 = ConnectorEditDialog.getMessage("selectDriverClass");
            Object object2 = JOptionPane.showInputDialog(this, string3, "", -1, null, objectArray = object.toArray(), objectArray[0]);
            if (object2 != null) {
                this.tDriver.setText((String)object2);
                this.tDriver.setCaretPosition(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryToConnect() {
        try {
            Connector connector = this.createConnector();
            Connection connection = connector.getConnection();
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = String.format("%s%n%s%s", ConnectorEditDialog.getMessage("try.connect"), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getDatabaseProductName());
                JOptionPane.showMessageDialog(this, string, null, 1);
            }
            finally {
                connection.close();
            }
        }
        catch (Throwable throwable) {
            WindowOutputProcessor.showErrorDialog(this, throwable);
        }
    }

    void requestClose(boolean bl) {
        if (bl) {
            if (JOptionPane.showConfirmDialog(this, Resource.getString("i.confirm-save", new Object[0]), "", 0) != 0) {
                return;
            }
            Connector connector = this.createConnector();
            ChangeEvent changeEvent = new ChangeEvent(connector);
            for (ChangeListener changeListener : this.listenerList) {
                changeListener.stateChanged(changeEvent);
            }
        } else if (JOptionPane.showConfirmDialog(this, Resource.getString("i.confirm-without-save", new Object[0]), "", 2) != 0) {
            return;
        }
        this.dispose();
    }

    private static String getMessage(String string) {
        return Resource.getString("ConnectorEditDialog." + string, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PasswordItem {
        final Class<? extends Password> passwordClass;

        PasswordItem(Class<? extends Password> clazz) {
            this.passwordClass = clazz;
        }

        Class<? extends Password> getPasswordClass() {
            return this.passwordClass;
        }

        String getName() {
            return this.toString();
        }

        public String toString() {
            return this.passwordClass.getName();
        }
    }
}

