/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;

public final class Report
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Report.class);

    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(this.getUsage());
        }
        try {
            String string = parameter.get(2);
            if (string.equals("-")) {
                this.reportDBInfo(connection);
            } else {
                String string2 = string;
                String string3 = parameter.get(3);
                if (string3.equalsIgnoreCase("PK")) {
                    this.reportPrimaryKeyInfo(connection, string2);
                } else if (string3.equalsIgnoreCase("INDEX")) {
                    this.reportIndexInfo(connection, string2);
                } else {
                    this.reportTableDescription(connection, string2);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportTableDescription(Connection connection, String string) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report table-description of : " + string);
        }
        ResultSet resultSet = connection.getMetaData().getColumns(null, null, this.convertPattern(string), null);
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(17, this.getColumnName("sequence"));
            columnOrder.addOrder(4, this.getColumnName("columnname"));
            columnOrder.addOrder(18, this.getColumnName("nullable"));
            columnOrder.addOrder(6, this.getColumnName("type"));
            columnOrder.addOrder(7, this.getColumnName("size"));
            columnOrder.addOrder(2, this.getColumnName("schema"));
            this.output(resultSetReference);
            this.outputMessage("i.selected", resultSetReference.getRecordCount());
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportPrimaryKeyInfo(Connection connection, String string) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report primary-key of : " + string);
        }
        ResultSet resultSet = connection.getMetaData().getPrimaryKeys(null, null, this.convertPattern(string));
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(1, this.getColumnName("catalog"));
            columnOrder.addOrder(2, this.getColumnName("schema"));
            columnOrder.addOrder(3, this.getColumnName("tablename"));
            columnOrder.addOrder(5, this.getColumnName("sequence"));
            columnOrder.addOrder(4, this.getColumnName("columnname"));
            columnOrder.addOrder(6, this.getColumnName("keyname"));
            this.output(resultSetReference);
            this.outputMessage("i.selected", resultSetReference.getRecordCount());
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportIndexInfo(Connection connection, String string) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report index of : " + string);
        }
        ResultSet resultSet = connection.getMetaData().getIndexInfo(null, null, this.convertPattern(string), false, false);
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(1, this.getColumnName("catalog"));
            columnOrder.addOrder(2, this.getColumnName("schema"));
            columnOrder.addOrder(3, this.getColumnName("tablename"));
            columnOrder.addOrder(8, this.getColumnName("sequence"));
            columnOrder.addOrder(9, this.getColumnName("columnname"));
            columnOrder.addOrder(6, this.getColumnName("keyname"));
            this.output(resultSetReference);
            this.outputMessage("i.selected", resultSetReference.getRecordCount());
        }
        finally {
            resultSet.close();
        }
    }

    private void reportDBInfo(Connection connection) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report dbinfo");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.outputMessage("Report.dbinfo", databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getDriverName(), databaseMetaData.getDriverVersion(), databaseMetaData.getUserName(), databaseMetaData.getURL());
    }

    private String getColumnName(String string) {
        return this.getMessage("Report.label." + string, new Object[0]);
    }
}

