/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Environment;
import net.argius.stew.Parameter;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;
import net.argius.stew.command.Find;
import net.argius.stew.command.Report;
import net.argius.stew.io.Exporter;
import net.argius.stew.io.Path;
import net.argius.stew.ui.OutputProcessor;

public final class Export
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Export.class);

    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(this.getUsage());
        }
        int n = 2;
        String string = parameter.get(n++);
        String string2 = parameter.get(n);
        boolean bl = false;
        if (string2.equalsIgnoreCase("HEADER")) {
            bl = true;
            ++n;
        }
        String string3 = parameter.getAll(n);
        try {
            this.export(connection, string, bl, new Parameter(string3));
            this.outputMessage("i.exported", new Object[0]);
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(Connection connection, String string, boolean bl, Parameter parameter) throws IOException {
        Command command = this.getCommand(parameter.get(1).replaceAll("\\s+", ""));
        Path path = Path.resolve(this.env.getCurrentDirectory(), string);
        Exporter exporter = Exporter.getExporter(path);
        try {
            if (log.isDebugEnabled()) {
                log.debug("command  : " + command);
                log.debug("exporter : " + exporter);
            }
            OutputProcessor outputProcessor = this.env.getOutputProcessor();
            ExporterOutputProcessor exporterOutputProcessor = new ExporterOutputProcessor(exporter, outputProcessor, bl);
            Environment environment = new Environment(this.env);
            environment.setOutputProcessor(exporterOutputProcessor);
            command.setEnvironment(environment);
            command.execute(connection, parameter);
        }
        finally {
            exporter.close();
        }
    }

    private Command getCommand(String string) {
        Command command;
        if (string.equalsIgnoreCase("SELECT")) {
            throw new UnsupportedOperationException("export SELECT");
        }
        if (string.equalsIgnoreCase("FIND")) {
            command = new Find();
        } else if (string.equalsIgnoreCase("REPORT")) {
            command = new Report();
        } else {
            throw new UsageException(this.getUsage());
        }
        return command;
    }

    private static final class ExporterOutputProcessor
    implements OutputProcessor {
        private static final Logger log = LoggerFactory.getLogger(ExporterOutputProcessor.class);
        private final Exporter exporter;
        private final OutputProcessor output;
        private final boolean withHeader;

        public ExporterOutputProcessor(Exporter exporter, OutputProcessor outputProcessor, boolean bl) {
            this.exporter = exporter;
            this.output = outputProcessor;
            this.withHeader = bl;
        }

        public void output(Object object) {
            try {
                if (object instanceof ResultSetReference) {
                    ResultSetReference resultSetReference = (ResultSetReference)object;
                    ColumnOrder columnOrder = resultSetReference.getOrder();
                    int n = this.outputResultSet(resultSetReference.getResultSet(), columnOrder);
                    resultSetReference.setRecordCount(n);
                } else {
                    this.output.output(object);
                }
            }
            catch (IOException iOException) {
                log.error("", iOException);
                this.output.output(iOException.getMessage());
            }
            catch (SQLException sQLException) {
                log.error("", sQLException);
                this.output.output(sQLException.getMessage());
            }
        }

        private int outputResultSet(ResultSet resultSet, ColumnOrder columnOrder) throws IOException, SQLException {
            int n;
            int n2;
            int n3 = 0;
            boolean bl = columnOrder.size() > 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl) {
                n2 = columnOrder.size();
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(columnOrder.getName(i));
                }
            } else {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                n2 = resultSetMetaData.getColumnCount();
                for (n = 0; n < n2; ++n) {
                    arrayList.add(resultSetMetaData.getColumnName(n + 1));
                }
            }
            if (this.withHeader) {
                this.exporter.addHeader(arrayList.toArray());
            }
            while (resultSet.next()) {
                ++n3;
                Object[] objectArray = new Object[n2];
                for (n = 0; n < n2; ++n) {
                    int n4 = bl ? columnOrder.getOrder(n) : n + 1;
                    objectArray[n] = resultSet.getObject(n4);
                }
                this.exporter.addRow(objectArray);
            }
            return n3;
        }

        public void close() {
        }
    }
}

