/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;

public final class Download
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Download.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(this.getUsage());
        }
        File file = new File(parameter.get(2));
        String string = parameter.getAll(3);
        if (log.isDebugEnabled()) {
            log.debug("file : " + file);
            log.debug("SQL : " + string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                Statement statement = connection.createStatement();
                try {
                    InputStream inputStream;
                    ResultSet resultSet = statement.executeQuery(string);
                    if (!resultSet.next()) {
                        this.outputMessage("e.no-record", new Object[0]);
                        return;
                    }
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n = resultSetMetaData.getColumnCount();
                    if (n != 1) {
                        this.outputMessage("w.column-count-not-1", new Object[0]);
                    }
                    switch (resultSetMetaData.getColumnType(1)) {
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            inputStream = resultSet.getBinaryStream(1);
                            break;
                        }
                        default: {
                            inputStream = resultSet.getAsciiStream(1);
                        }
                    }
                    try {
                        int n2;
                        long l = 0L;
                        byte[] byArray = new byte[8192];
                        while ((n2 = inputStream.read(byArray)) > 0) {
                            fileOutputStream.write(byArray, 0, n2);
                            l += (long)n2;
                        }
                        this.outputMessage("i.downloaded", Float.valueOf((float)l / 1024.0f));
                    }
                    finally {
                        inputStream.close();
                    }
                    if (resultSet.next()) {
                        this.outputMessage("w.records-more-than-1", new Object[0]);
                    }
                }
                finally {
                    statement.close();
                }
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }
}

