/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.argius.stew.CommandException;
import net.argius.stew.CommandProcessor;
import net.argius.stew.Environment;
import net.argius.stew.Parameter;

public abstract class Command {
    private static final String SELECT = "SELECT";
    private static final int SELECT_LENGTH = "SELECT".length();
    protected Environment env;
    private final ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".messages");

    protected Command() {
    }

    public void initialize() throws CommandException {
    }

    public abstract void execute(Connection var1, Parameter var2) throws CommandException;

    public void close() throws CommandException {
    }

    public static boolean invoke(Environment environment, String string) throws CommandException {
        CommandProcessor commandProcessor = new CommandProcessor(environment);
        return commandProcessor.invoke(string);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected void setTimeout(Statement statement) throws SQLException {
        int n = this.env.getTimeoutSeconds();
        if (n >= 0) {
            statement.setQueryTimeout(n);
        }
    }

    public final void setEnvironment(Environment environment) {
        this.env = environment;
    }

    protected final void output(Object object) throws CommandException {
        this.env.getOutputProcessor().output(object);
    }

    protected final void outputMessage(String string, Object ... objectArray) throws CommandException {
        this.output(this.getMessage(string, objectArray));
    }

    protected final String getMessage(String string, Object ... objectArray) {
        try {
            String string2 = this.resourceBundle.getString(string);
            if (objectArray.length == 0) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return "?(" + string + Arrays.asList(objectArray) + ')';
        }
    }

    protected final String convertPattern(String string) throws SQLException {
        DatabaseMetaData databaseMetaData = this.env.getCurrentConnection().getMetaData();
        String string2 = databaseMetaData.storesLowerCaseIdentifiers() ? string.toLowerCase() : (databaseMetaData.storesUpperCaseIdentifiers() ? string.toUpperCase() : string);
        return string2.replace('*', '%').replace('?', '_');
    }

    protected String getUsage() {
        String string = this.getClass().getName().replaceFirst(".*\\.([^\\.]+)", "$1");
        return this.getMessage("usage." + string, new Object[0]);
    }

    protected static boolean isSelect(String string) {
        if (string != null && string.length() >= SELECT_LENGTH) {
            return SELECT.equalsIgnoreCase(string.substring(0, SELECT_LENGTH));
        }
        return false;
    }
}

