using System;
using System.Collections.Generic;
using System.Text;
using Ruby;
using VALUE = System.Int32;
using ID = System.Int32;

namespace StarEngine.Ruby
{
    public partial class RubyInterpreter
    {
        private void InitializeGameModule()
        {
            VALUE mGame = SERubyConsts.ForName("Game");

            RUBY.rb_define_singleton_method(mGame, "fps",
                delegate(VALUE self)
                {
                    return RUBY.INT2NUM(Game.Fps);
                });

            RUBY.rb_define_singleton_method(mGame, "fps=",
                delegate(VALUE self, VALUE rbFps)
                {
                    this.Game.Fps = RUBY.NUM2INT(rbFps);
                    return rbFps;
                });

            RUBY.rb_define_singleton_method(mGame, "real_fps",
                delegate(VALUE self)
                {
                    return RUBY.rb_float_new(GameEnvironment.RealFps);
                });

            RUBY.rb_define_singleton_method(mGame, "__cs_game_run__",
                delegate(VALUE self)
                {
                    this.GameEnvironment.Run(Game);
                    return RUBY.Qnil;
                });

            RUBY.rb_define_singleton_method(mGame, "running?",
                delegate(VALUE self)
                {
                    return this.GameEnvironment.IsRunning ? RUBY.Qtrue : RUBY.Qfalse;
                });

            RUBY.rb_define_singleton_method(mGame, "terminate",
                delegate(VALUE self)
                {
                    this.GameEnvironment.Terminate();
                    return RUBY.Qnil;
                });

            RUBY.rb_define_singleton_method(mGame, "title",
                delegate(VALUE self)
                {
                    return RUBY.rb_str_new2(Game.Title);
                });

            RUBY.rb_define_singleton_method(mGame, "title=",
                delegate(VALUE self, VALUE rbTitle)
                {
                    string csTitle = RUBY.StringValuePtr(rbTitle);
                    this.Game.Title = csTitle;
                    this.GameEnvironment.Title = csTitle;
                    return rbTitle;
                });
        }
    }
}