using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Xml;
using StarEngine.Core;
using StarEngine.Ruby;
using StarEngine.Sdl;

namespace StarEngine
{
    public class Program
    {
        public static void Main()
        {
            try
            {
                if (Process.GetProcessesByName(Process.GetCurrentProcess().ProcessName).Length > 1)
                {
                    MessageBox.Show("dN͏o܂B");
                    return;
                }

                Directory.SetCurrentDirectory("./Game");

                WindowType windowType = StarEngine.Properties.Settings.Default.WindowType;

                using (GameEnvironment env = GameEnvironment.Create(windowType))
                using (RubyInterpreter interpreter = RubyInterpreter.Create(env))
                {
                    interpreter.AddLoadPath("./Scripts");

                    string mainScript;
                    using (StreamReader reader = File.OpenText("Scripts/main.rb"))
                        mainScript = reader.ReadToEnd();

                    string mainScriptEscaped = mainScript.Replace("'", "\\\'");

                    interpreter.Evaluate("begin\n" +
                        "  eval('" + mainScriptEscaped + "', binding, './Scripts/main.rb', 1)\n" +
                        "rescue\n" +
                        "  puts($!.message)\n" +
                        "  puts($!.backtrace)\n" +
                        "  StarEngine::activate_console\n" +
                        "end");
                }
            }
            catch (Exception e)
            {
                using (CrashReportDialog crashReportDialog = new CrashReportDialog(e))
                    crashReportDialog.ShowDialog();
            }
        }
    }
}
