using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace StarEngine.Ruby
{
    internal static class PathExtensions
    {
        /// <summary>
        /// gq̏ȗlāAtpX擾܂B
        /// </summary>
        /// <param name="path">pXB</param>
        /// <returns>tpXB</returns>
        public static string GetFullPathAndExtension(string path)
        {
            path = Path.GetFullPath(path);
            if (File.Exists(path))
                return path;

            string dir = Path.GetDirectoryName(path);
            if (!Directory.Exists(dir))
                return path;

            string[] files = Directory.GetFiles(dir, Path.GetFileName(path) + ".*");
            if (files.Length == 0)
                return path;

            Array.Sort<string>(files);
            return files[0];
        }
    }
}
