/*
 * 

  SQSNamespaces.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sqs2.xmlns;

import java.util.HashMap;
import java.util.Map;

public class SQSNamespaces {

	public static final String SQS2004_PREFIX = "sqs";
	public static final String SQS2004_URI = "http://sqs.cmr.sfc.keio.ac.jp/2004/sqs";

	public static final String SQS2004READER_PREFIX = "reader";
	public static final String SQS2004READER_URI = "http://sqs.cmr.sfc.keio.ac.jp/2004/reader";

	public static final String SQS2007MASTER_PREFIX = "master";
	public static final String SQS2007MASTER_URI = "http://sqs-xml.sourceforge.jp/2007/master";

	public static final String XFORMS_PREFIX = "xforms";
	public static final String XFORMS_URI = "http://www.w3.org/2002/xforms";

	public static final String XHTML2_PREFIX = "xhtml2";
	public static final String XHTML2_URI_WITH_BUG = "http://www.w3.org/TR/xhtml2";
	public static final String XHTML2_URI = "http://www.w3.org/2002/06/xhtml2";

	public static final String XHTML_PREFIX = "xhtml";
	public static final String XHTML_URI = "http://www.w3.org/1999/xhtml";

	public static final String SVG_PREFIX = "svg";
	public static final String SVG_URI = "http://www.w3.org/2000/svg";

	public static Map<String, String> createPrefixMap() {
		Map<String, String> map = new HashMap<String, String>();
		map.put(SQSNamespaces.SQS2004_PREFIX, SQSNamespaces.SQS2004_URI);
		map.put(SQSNamespaces.SQS2004READER_PREFIX, SQSNamespaces.SQS2004READER_URI);
		map.put(SQSNamespaces.XFORMS_PREFIX, SQSNamespaces.XFORMS_URI);
		map.put(SQSNamespaces.XHTML2_PREFIX, SQSNamespaces.XHTML2_URI);
		map.put(SQSNamespaces.XHTML_PREFIX, SQSNamespaces.XHTML_URI);
		map.put(SQSNamespaces.SVG_PREFIX, SQSNamespaces.SVG_URI);
		return map;
	}
}
