package net.sqs2.net;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;

public class ClassURLConnection extends URLConnection {

	private Class<?> clazz;

	public ClassURLConnection(URL url) {
		super(url);
	}

	@Override
	public String getContentType() {
		return guessContentTypeFromName(this.url.getPath());
	}

	@Override
	public synchronized InputStream getInputStream() throws IOException {
		if ("class".equals(this.url.getProtocol())) {
			if (!this.connected) {
				connect();
			}
			this.setDefaultUseCaches(true);
			String path = this.url.getPath();
			if (path.startsWith("/")) {
				path = path.substring(1);
			}
			ClassLoader classLoader = this.clazz.getClassLoader();
			if (classLoader == null) {
				String message = "Cannot load : " + this.url.getProtocol() + " / " + path;
				Logger.getAnonymousLogger().severe(message);
				throw new IOException(message);
			}
			return classLoader.getResourceAsStream(path);
		} else if ("http".equals(this.url.getProtocol())) {
			// Logger.getAnonymousLogger().info(this.url.toString());
			return super.getInputStream();
			/*
			 * HttpClient client = new DefaultHttpClient(); HttpGet httpGet =
			 * new HttpGet(this.url.toString()); HttpResponse response =
			 * client.execute(httpGet); InputStream in =
			 * response.getEntity().getContent(); try { int length =
			 * (int)response.getEntity().getContentLength(); byte bytes[] = new
			 * byte[length]; int off = 0, readLength = 0; while(0 < (readLength
			 * = in.read(bytes, off, length - off))){ off += readLength; }
			 * return new ByteArrayInputStream(bytes); } catch (IOException ex)
			 * { System.err.println("Fatal transport error: " +
			 * ex.getMessage()); ex.printStackTrace(); } finally { in.close(); }
			 * return null;
			 */
		} else if ("file".equals(this.url.getProtocol())) {
			return new BufferedInputStream(new FileInputStream(this.url.getPath()));
		} else {
			System.err.println("'protocol:" + this.url + "----" + this.url.getProtocol() + "----"
					+ this.url.getPath());
			this.connected = false;
			throw new IOException();
		}
	}

	@Override
	public synchronized void connect() throws IOException {
		String className = this.url.getHost();
		try {
			this.clazz = Class.forName(className);
			this.connected = true;
		} catch (ClassNotFoundException ex) {
			throw new RuntimeException("Class not found: " + ex.toString());
		}
	}
}
