package net.sqs2.omr.session.service;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;

import net.sqs2.net.ClassURLStreamHandlerFactory;
import net.sqs2.omr.app.MergedFormMasterFactory;
import net.sqs2.omr.app.service.RemoveResultFoldersService;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.master.FormMasterFactory;
import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.master.PageMasterException;
import net.sqs2.omr.model.PageTaskException;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.session.monitor.MarkReaderSessionMonitor;
import net.sqs2.omr.session.monitor.MarkReaderSessionMonitorAdapter;
import net.sqs2.omr.session.source.SessionSource;
import net.sqs2.omr.session.source.SessionSourceContentIndexer;
import net.sqs2.omr.session.source.SessionSourceException;
import net.sqs2.omr.session.source.SessionStopException;
import net.sqs2.omr.session.source.SourceInitializationStopException;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SessionSourceFactoryServiceTest {

	
	File testDirectory1 = new File("src/test/resources/test1");
	File testDirectory2 = new File("src/test/resources/test2");
	
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		try {
			URL.setURLStreamHandlerFactory(new ClassURLStreamHandlerFactory());
		} catch (Error ex) {
			ex.printStackTrace();
		}
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
		new RemoveResultFoldersService(testDirectory1).call();
		new RemoveResultFoldersService(testDirectory2).call();
	}

	@Test
	public void testInitialize(){
		long sessionID = 0L;
		
		File rootDirectory = testDirectory1.getAbsoluteFile();
		try{
			FormMasterFactory masterFactory = new MergedFormMasterFactory();
			MarkReaderSessionMonitor monitor = new MarkReaderSessionMonitorAdapter(); 
			SessionSourceFactoryService task = new SessionSourceFactoryService(sessionID, rootDirectory, masterFactory, monitor);
			SessionSource sessionSource = task.call();
			sessionSource.initialize();
			SessionSourceContentIndexer indexer = sessionSource.getSessionSourceContentIndexer();
			List<PageMaster> pageMasterList = indexer.getPageMasterList();

			assertTrue(sessionSource.getRootDirectory().isDirectory());
			assertEquals(1, pageMasterList.size());
			
			FormMaster master = (FormMaster)pageMasterList.get(0);
			List<SourceDirectory> sourceDirectoryList = indexer.getSourceDirectoryList(master);
			assertEquals(1, sourceDirectoryList.size());
			
			SourceDirectory sourceDirectory = sourceDirectoryList.get(0);
			assertEquals(0, sourceDirectory.getNumChildSourceDirectories());
			assertEquals(0, sourceDirectory.getDescendentSourceDirectoryList().size());
			
			assertEquals(22, sourceDirectory.getNumPageIDs());
			assertEquals(22, sourceDirectory.getNumPageIDsTotal());
			
			assertEquals(0, sourceDirectory.getID());
			
			assertEquals("", sourceDirectory.getPath());
			assertEquals(rootDirectory, sourceDirectory.getRoot());
			
		}catch(PageMasterException ex){
			ex.printStackTrace();
		}catch(SessionStopException ex){
			ex.printStackTrace();
		}catch(SourceInitializationStopException ex){
			ex.printStackTrace();
		}catch(SessionSourceException ex){
			ex.printStackTrace();
		}catch(PageTaskException ex){
			ex.printStackTrace();
		}catch(IOException ex){
			ex.printStackTrace();
		}
	}


	@Test
	public void testInitializeMultiDepthFolder(){
		long sessionID = 0L;
		
		File rootDirectory = testDirectory2.getAbsoluteFile();
		try{
			FormMasterFactory masterFactory = new MergedFormMasterFactory();
			MarkReaderSessionMonitor monitor = new MarkReaderSessionMonitorAdapter(); 
			SessionSourceFactoryService task = new SessionSourceFactoryService(sessionID, rootDirectory, masterFactory, monitor);
			SessionSource sessionSource = task.call();
			sessionSource.initialize();
			SessionSourceContentIndexer indexer = sessionSource.getSessionSourceContentIndexer();
			List<PageMaster> pageMasterList = indexer.getPageMasterList();

			assertTrue(sessionSource.getRootDirectory().isDirectory());
			assertEquals(1, pageMasterList.size());
			
			FormMaster master = (FormMaster)pageMasterList.get(0);
			List<SourceDirectory> sourceDirectoryList = indexer.getSourceDirectoryList(master);
			assertEquals(4, sourceDirectoryList.size());
			
			SourceDirectory sourceDirectory1 = sourceDirectoryList.get(0);
			SourceDirectory sourceDirectory2 = sourceDirectoryList.get(1);
			SourceDirectory sourceDirectory3 = sourceDirectoryList.get(2);
			SourceDirectory rootSourceDirectory = sourceDirectoryList.get(sourceDirectoryList.size()-1);
			
			assertEquals(rootDirectory, rootSourceDirectory.getRoot());
			assertEquals("", rootSourceDirectory.getPath());
			assertEquals(3, rootSourceDirectory.getNumChildSourceDirectories());
			assertEquals(3, rootSourceDirectory.getDescendentSourceDirectoryList().size());
			assertEquals(0, rootSourceDirectory.getNumPageIDs());
			assertEquals(50, rootSourceDirectory.getNumPageIDsTotal());
			assertEquals(4, rootSourceDirectory.getID());
			
			assertEquals("A", sourceDirectory1.getPath());
			assertEquals(0, sourceDirectory1.getNumChildSourceDirectories());
			assertEquals(0, sourceDirectory1.getDescendentSourceDirectoryList().size());
			assertEquals(30, sourceDirectory1.getNumPageIDs());
			assertEquals(30, sourceDirectory1.getNumPageIDsTotal());
			assertEquals(1, sourceDirectory1.getID());
			
			assertEquals("B", sourceDirectory2.getPath());
			assertEquals(0, sourceDirectory2.getNumChildSourceDirectories());
			assertEquals(0, sourceDirectory2.getDescendentSourceDirectoryList().size());
			assertEquals(10, sourceDirectory2.getNumPageIDs());
			assertEquals(10, sourceDirectory2.getNumPageIDsTotal());
			assertEquals(2, sourceDirectory2.getID());
			
			assertEquals("C", sourceDirectory3.getPath());
			assertEquals(0, sourceDirectory3.getNumChildSourceDirectories());
			assertEquals(0, sourceDirectory3.getDescendentSourceDirectoryList().size());
			assertEquals(10, sourceDirectory3.getNumPageIDs());
			assertEquals(10, sourceDirectory3.getNumPageIDsTotal());
			assertEquals(3, sourceDirectory3.getID());
			
		}catch(PageMasterException ex){
			ex.printStackTrace();
		}catch(SessionStopException ex){
			ex.printStackTrace();
		}catch(SourceInitializationStopException ex){
			ex.printStackTrace();
		}catch(SessionSourceException ex){
			ex.printStackTrace();
		}catch(PageTaskException ex){
			ex.printStackTrace();
		}catch(IOException ex){
			ex.printStackTrace();
		}
	}
}
