package net.sqs2.omr.session.service;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import junit.framework.TestCase;
import net.sqs2.net.ClassURLStreamHandlerFactory;
import net.sqs2.omr.app.MarkReaderApp;
import net.sqs2.omr.app.service.RemoveResultFoldersService;
import net.sqs2.omr.session.monitor.MarkReaderSessionMonitorAdapter;
import net.sqs2.omr.session.source.SessionSources;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;

public class MarkReaderSessionImplTest extends TestCase {

	final File sourceDirectoryRoot = new File("src/test/resources/test1");
	MarkReaderApp markReaderApp;
	MarkReaderSessionService session;
	
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {

	}

	@Before
	public void setUp() throws Exception {
		try {
			URL.setURLStreamHandlerFactory(new ClassURLStreamHandlerFactory());
		} catch (Error ex) {
		}
		boolean isLocalTaskExecutorEnabled = true;
		markReaderApp = new MarkReaderApp(1099,
				isLocalTaskExecutorEnabled);
		session = markReaderApp.createSession(sourceDirectoryRoot);
		session.setGUIMode(false);
	}

	@After
	public void tearDown() throws Exception {
		try{
			new RemoveResultFoldersService(sourceDirectoryRoot).call();
		}catch(Exception ex){
			ex.printStackTrace();
		}
	}

	public void testStartSession() {
		try{

			session.addSessionMonitor(new MarkReaderSessionMonitorAdapter() {
				@Override
				public void notifySessionFinished(File sourceDirectoryRootFile) {
					List<Long> sessionIDList = SessionSources.getSessionIDList();
					long sid = sessionIDList.get(sessionIDList.size() - 1);
					markReaderApp.shutdown();
					System.err.println("FINISHED!");
				}
			});
			
			session.startSession();
			
			Future<Boolean> future = Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){
				public Boolean call(){
					try{
						for(int countDown = 300; 0 < countDown ; countDown--){
							try{
								Thread.sleep(500);
							}catch(InterruptedException ignore){}
							if(session.hasStopped()){
								return Boolean.TRUE;
							}
						}
						return Boolean.FALSE;
					}finally{
					}
				}
			});
			
			boolean sessionHasStopped = future.get();
			assertTrue(sessionHasStopped);
			
		}catch(Exception ex){
			ex.printStackTrace();
			this.fail();
		}
	}

}
