package net.sqs2.swing;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;

public class SVGViewerPanel extends JPanel {

	private static final long serialVersionUID = 0L;

	public static void main(String[] args) {
		JFrame f = new JFrame("Batik");
		SVGViewerPanel app = new SVGViewerPanel(f);
		f.getContentPane().add(app.createComponents());

		f.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		f.setSize(400, 400);
		f.setVisible(true);
	}

	JFrame frame;
	JButton button = new JButton("Load...");
	JLabel label = new JLabel();
	JSVGCanvas svgCanvas = new JSVGCanvas();

	public SVGViewerPanel(JFrame f) {
		this.frame = f;
	}

	public JComponent createComponents() {
		final JPanel panel = new JPanel(new BorderLayout());

		JPanel p = new JPanel(new FlowLayout(FlowLayout.LEFT));
		p.add(this.button);
		p.add(this.label);

		panel.add("North", p);
		panel.add("Center", this.svgCanvas);

		// Set the button action.
		this.button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				JFileChooser fc = new JFileChooser(".");
				int choice = fc.showOpenDialog(panel);
				if (choice == JFileChooser.APPROVE_OPTION) {
					File f = fc.getSelectedFile();
					SVGViewerPanel.this.svgCanvas.setURI(f.toURI().toString());
				}
			}
		});

		// Set the JSVGCanvas listeners.
		this.svgCanvas.addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter() {
			@Override
			public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
				SVGViewerPanel.this.label.setText("Document Loading...");
			}

			@Override
			public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
				SVGViewerPanel.this.label.setText("Document Loaded.");
			}
		});

		this.svgCanvas.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter() {
			@Override
			public void gvtBuildStarted(GVTTreeBuilderEvent e) {
				SVGViewerPanel.this.label.setText("Build Started...");
			}

			@Override
			public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
				SVGViewerPanel.this.label.setText("Build Done.");
				SVGViewerPanel.this.frame.pack();
			}
		});

		this.svgCanvas.addGVTTreeRendererListener(new GVTTreeRendererAdapter() {
			@Override
			public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
				SVGViewerPanel.this.label.setText("Rendering Started...");
			}

			@Override
			public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
				SVGViewerPanel.this.label.setText("");
			}
		});

		return panel;
	}

}
