package net.sqs2.spreadsheet;

import java.io.IOException;
import java.io.OutputStream;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SpreadSheetWorkbook {
	protected Workbook currentWorkbook = null;

	protected Row currentRow;

	private String currentSheetName = null;
	private int currentRowIndex = -1;

	public SpreadSheetWorkbook(Workbook workbook) {
		this.currentWorkbook = workbook;
	}

	public Workbook getWorkbook() {
		return this.currentWorkbook;
	}

	public void writeTo(OutputStream xlsOutputStream) throws IOException {
		this.currentWorkbook.write(xlsOutputStream);
	}

	public int getSheetIndex(String sheetName) {
		getSheet(sheetName);
		return this.currentWorkbook.getSheetIndex(sheetName);
	}

	public Sheet getSheet(String sheetName) {
		Sheet sheet = this.currentWorkbook.getSheet(sheetName);
		if (sheet == null) {
			sheet = createSheet(sheetName);
		}
		return sheet;
	}

	protected Sheet createSheet(String sheetName) {
		return this.currentWorkbook.createSheet(sheetName);
	}

	public Row getRow(String sheetName, int rowIndex) {
		if (sheetName.equals(this.currentSheetName) && this.currentRowIndex == rowIndex) {
			return this.currentRow;
		}
		Sheet sheet = getSheet(sheetName);
		Row row = sheet.getRow(rowIndex);
		if (row == null) {
			row = sheet.createRow(rowIndex);
		}
		this.currentSheetName = sheetName;
		this.currentRowIndex = rowIndex;
		return this.currentRow = row;
	}

	public Cell getCell(String sheetName, int rowIndex, int columnIndex) {
		return getCell(getRow(sheetName, rowIndex), columnIndex);
	}

	public Cell getCell(Row row, int columnIndex) {
		Cell cell = row.getCell(columnIndex);
		if (cell == null) {
			cell = row.createCell(columnIndex);
		}
		return cell;
	}
	
	public Font createFont(){
		return this.currentWorkbook.createFont();
	}
	
	public CellStyle createCellStyle(){
		return this.currentWorkbook.createCellStyle();
	}

}
