/*

 VelocityViewServlet.java

 Copyright 2008 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/11/01

 */

package net.sqs2.servlet;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sqs2.template.TemplateLoader;
import freemarker.template.Template;

public abstract class FreeMarkerViewServlet extends HttpServlet {
	private static final long serialVersionUID = 0L;
	private File userConfigDir;
	protected String skinName;
	
	public FreeMarkerViewServlet(File userConfigDir, String skinName) throws ServletException {
		super();
		this.userConfigDir = userConfigDir;
		this.skinName = skinName;
	}

	@Override
	protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		res.setContentType("text/html; charset=UTF-8");
		res.setHeader("CacneControl", "no-cache;");
		long sessionID = Long.parseLong(req.getParameter("sid"));
		writeTo(res.getWriter(), createTemplate(sessionID, getTemplateFileName(), skinName, "UTF-8", userConfigDir), createMap(sessionID));
	}

	protected String getTemplateFileName() {
		throw new RuntimeException("not implemented yet");
	}
	
	public String getSkinName(){
		return this.skinName;
	}
	
	protected abstract Map<String,Object> createMap(long sessionID);

	protected Template createTemplate(long sessionID, String filename, String skinName, String encoding, File userConfigDir) throws IOException{
		TemplateLoader loader = new TemplateLoader(userConfigDir, "ftl", skinName);
		Template template = loader.getTemplate(filename, encoding);
		return template;
	}

	private void writeTo(Writer writer, Template template, Map<String,Object> map) {
		try {
			template.process(map, writer);
			writer.flush();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
