/*

 SessionProgressPanel.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/2/11

 */
package net.sqs2.omr.swing.session;

import java.awt.Color;
import java.awt.Cursor;
import java.io.File;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import net.sqs2.omr.model.PageTask;
import net.sqs2.omr.session.model.PageTaskExecutionProgressModel;
import net.sqs2.omr.session.monitor.MarkReaderSessionMonitorAdapter;
import net.sqs2.sound.SoundManager;

public class PageTaskExecutionProgressPanel extends JPanel {
	private static final long serialVersionUID = 0L;

	protected PageTaskExecutionProgressModel pageTaskExecutionProgressModel;

	boolean isNowUpdating = false;

	public PageTaskExecutionProgressPanel() {
		this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
	}

	Future<?> sessionTimer = null;
	
	public PageTaskExecutionProgressPanel(PageTaskExecutionProgressModel model) {
		this.pageTaskExecutionProgressModel = model;
		this.pageTaskExecutionProgressModel.addSessionMonitor(new MarkReaderSessionMonitorAdapter() {
			
			@Override
			public void notifySessionStarted(File sourceDirectoryRootFile) {
				super.notifySessionStarted(sourceDirectoryRootFile);
				if(sessionTimer != null){
					sessionTimer.cancel(true);
				}
				sessionTimer = new ScheduledThreadPoolExecutor(1).scheduleAtFixedRate(new Runnable(){
					public void run(){
						update();
					}
				}, 1, 1, TimeUnit.SECONDS);
			}

			@Override
			public void notifySessionFinished(File sourceDirectoryRootFile) {
				super.notifySessionFinished(sourceDirectoryRootFile);
				if(sessionTimer != null){
					sessionTimer.cancel(true);
				}
			}

			@Override
			public void notifySessionStopped(File sourceDirectoryRootFile) {
				super.notifySessionStopped(sourceDirectoryRootFile);
				if(sessionTimer != null){
					sessionTimer.cancel(true);
				}
			}

			@Override
			public void notifyPageTaskProduced(PageTask pageTask) {
				update();
			}

			@Override
			public void notifyStoreTask(PageTask pageTask) {
				SoundManager.getInstance().play("pyoro37_b.wav");
				update();
			}
		});
		this.setBackground(Color.WHITE);
	}

	public PageTaskExecutionProgressModel getProgressModel() {
		return this.pageTaskExecutionProgressModel;
	}

	protected synchronized void update() {
		if(isNowUpdating){
			return;
		}
		isNowUpdating = true;
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				repaint();
			}
		});
		isNowUpdating = false;
	}

}
