/**
 * 
 */
package net.sqs2.omr.swing.session;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.io.File;

import javax.swing.JTable;

import net.sqs2.omr.model.PageTaskError;
import net.sqs2.omr.model.PageTaskExceptionModel;
import net.sqs2.omr.session.logic.CornerBlockMissingExceptionModel;
import net.sqs2.omr.session.logic.PageFrameDistortionExceptionModel;
import net.sqs2.omr.session.logic.PageSequenceInvalidExceptionModel;
import net.sqs2.omr.session.logic.PageUpsideDownExceptionModel;
import net.sqs2.omr.session.logic.PageImageSourceException.PageSourceExceptionModel;
import net.sqs2.omr.session.model.PageTaskErrorTableCell;
import net.sqs2.swing.ImageThumbnailTableCellRenderer;
import net.sqs2.swing.ThumbnailCacheManager;
import net.sqs2.swing.ThumbnailEntry;

class PageTaskErrorTableCellRenderer extends ImageThumbnailTableCellRenderer {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	boolean isSelected;
	boolean hasFocus;
	Font font = new Font("Serif", Font.PLAIN, 13);
	Color selectedColor;

	PageTaskErrorTableCellRenderer() {
	}

	@Override
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
		return this;
	}

	@Override
	public void paintComponent(Graphics g) {

		super.paintComponent(g);

		PageTaskError taskError = ((PageTaskErrorTableCell) this.cell).getTaskError();
		if (taskError == null) {
			return;
		}
		PageTaskExceptionModel model = taskError.getExceptionModel();
		String message = model.getLocalizedMessage();
		g.drawString(message, 0, getHeight() - 3);

		int compWidth = this.getWidth();
		String path = this.cell.getPath();
		File file = new File(this.cell.getRoot(), path);
		ThumbnailEntry entryValue = ThumbnailCacheManager.loadImage(file);
		Image thumbnail = entryValue.getImage();
		if (thumbnail == null) {
			return;
		}
		int w = thumbnail.getWidth(null);
		int h = thumbnail.getHeight(null);

		int x0 = (compWidth - w) / 2;
		int y0 = 0;

		if (model instanceof PageFrameDistortionExceptionModel) {
			PageFrameDistortionExceptionModel m = (PageFrameDistortionExceptionModel) model;
			Point[] corners = m.getCorners();

			String detailUpper = "(" + corners[0].x + "," + corners[0].y + ")(" + corners[1].x + ","
					+ corners[1].y + ")";
			g.drawString(detailUpper, 0, 14 - 3);
			String detailLower = "(" + corners[2].x + "," + corners[2].y + ")(" + corners[3].x + ","
					+ corners[3].y + ")";
			g.drawString(detailLower, 0, 28 - 3);

			int originalImageWidth = entryValue.getOriginalImageWidth();
			int originalImageHeight = entryValue.getOriginalImageHeight();

			g.setColor(new Color(255, 0, 0, 100));
			g.drawPolygon(
					new int[] { x0 + corners[0].x * w / originalImageWidth,
							x0 + corners[1].x * w / originalImageWidth,
							x0 + corners[3].x * w / originalImageWidth,
							x0 + corners[2].x * w / originalImageWidth,
							x0 + corners[0].x * w / originalImageWidth, }, new int[] {
							y0 + corners[0].y * h / originalImageHeight,
							y0 + corners[1].y * h / originalImageHeight,
							y0 + corners[3].y * h / originalImageHeight,
							y0 + corners[2].y * h / originalImageHeight,
							y0 + corners[0].y * h / originalImageHeight, }, 5);

		} else if (model instanceof PageSourceExceptionModel) {
			PageSourceExceptionModel m = (PageSourceExceptionModel) model;
			String detail = m.getPageID() + ":(" + m.getX() + "," + m.getY() + ") [" + m.getWidth() + ","
					+ m.getHeight() + "]";
			g.drawString(detail, 0, 14 - 3);
		} else if (model instanceof PageUpsideDownExceptionModel) {
			//PageUpsideDownExceptionModel c = (PageUpsideDownExceptionModel) model;
			// TODO

		} else if (model instanceof CornerBlockMissingExceptionModel) {
			//CornerBlockMissingExceptionModel m = (CornerBlockMissingExceptionModel) model;
			// TODO

		} else if (model instanceof PageSequenceInvalidExceptionModel) {
			// TODO
			PageSequenceInvalidExceptionModel m = (PageSequenceInvalidExceptionModel) model;
			m.getCorners();

		}
	}

}
