package net.sqs2.omr.swing.session;

import java.awt.Color;

import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

import net.sqs2.omr.event.MasterEvent;
import net.sqs2.omr.event.ResultEvent;
import net.sqs2.omr.event.RowEvent;
import net.sqs2.omr.event.RowGroupEvent;
import net.sqs2.omr.event.SourceDirectoryEvent;
import net.sqs2.omr.result.export.SessionResultExportModule;
import net.sqs2.omr.result.export.model.MarkAreaErrorModel;
import net.sqs2.omr.swing.Messages;

public class MarkReaderSessionResultWalkerController extends SessionResultExportModule{
	
	public static final Color COLOR_UPDATE_PROGRESS_BAR_FINISHED = new Color(20, 210, 20);
	public static final Color COLOR_UPDATE_PROGRESS = new Color(20, 150, 20);
	
	MarkReaderSessionResultWalkerPanel walkerPanel;
	MarkAreaErrorModel markAreaErrorModel;
	
	public MarkReaderSessionResultWalkerController(MarkReaderSessionResultWalkerPanel walkerPanel, MarkAreaErrorModel markAreaErrorModel){
		this.walkerPanel = walkerPanel;
		this.markAreaErrorModel = markAreaErrorModel;
	}
	
	@Override
	public void startMaster(MasterEvent masterEvent) {
		super.startMaster(masterEvent);
		updateProgressValue(this.walkerPanel.getSessionExportProgressPanel().masterLabel, masterEvent, true);
	}

	@Override
	public void endMaster(MasterEvent masterEvent) {
		super.endMaster(masterEvent);
		updateProgressValue(this.walkerPanel.getSessionExportProgressPanel().masterLabel, masterEvent, false);
	}
	
	@Override
	public void startSourceDirectory(SourceDirectoryEvent sourceDirectoryEvent){
		updateProgressValue(this.walkerPanel.getSessionExportProgressPanel().sourceDirectoryLabel, sourceDirectoryEvent, true);
	}

	@Override
	public void endSourceDirectory(SourceDirectoryEvent sourceDirectoryEvent) {
		super.endSourceDirectory(sourceDirectoryEvent);
		updateProgressValue(this.walkerPanel.getSessionExportProgressPanel().sourceDirectoryLabel, sourceDirectoryEvent, false);
	}
	
	@Override
	public void startRowGroup(RowGroupEvent rowGroupEvent) {
		super.startRowGroup(rowGroupEvent); // do not remove
		updateProgressValue(this.walkerPanel.getSessionExportProgressPanel().rowGroupLabel, rowGroupEvent, true);
	}

	@Override
	public void endRowGroup(RowGroupEvent rowGroupEvent) {
		super.endRowGroup(rowGroupEvent); // do not remove
		updateProgressValue(this.walkerPanel.getSessionExportProgressPanel().rowGroupLabel, rowGroupEvent, false);
	}

	@Override
	public void startRow(RowEvent rowEvent) {
		super.startRow(rowEvent); // do not remove
		//this.markAreaErrorModel.setRowIndex(rowEvent.getRowIndex());
		updateProgressValue(this.walkerPanel.getSessionExportProgressPanel().rowLabel, rowEvent, true);
	}

	@Override
	public void endRow(RowEvent rowEvent) {
		super.endRow(rowEvent); // do not remove
		updateProgressValue(this.walkerPanel.getSessionExportProgressPanel().rowLabel, rowEvent, false);
		this.walkerPanel.getSessionResultStatisticsPanel().updateValue(this.markAreaErrorModel.getTotalMarkReadStatus());
	}
	
	private void updateProgressBar(final JProgressBar progressBar, final int index, final int max, final boolean isFinished) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				progressBar.setIndeterminate(false);
				progressBar.setMinimum(0);
				progressBar.setMaximum(max);
				progressBar.setValue(index);
				if (isFinished) {
					progressBar.setString(Messages.EXPORT_FINISHED_LABEL+": " + index + " / " + max);
					progressBar.setForeground(COLOR_UPDATE_PROGRESS_BAR_FINISHED);
				} else {
					progressBar.setString(Messages.EXPORT_PROGRESS_LABEL+": " + index + " / " + max);
					progressBar.setForeground(COLOR_UPDATE_PROGRESS);
				}
			}
		});
	}

	private void updateProgressValue(LabelProgressPanel panel, ResultEvent event, boolean isStart) {
		boolean isFinished = !isStart && (event.getIndex()+1 == event.getNumEvents()); 
		JProgressBar progressBar = panel.getProgressBar();
		updateProgressBar(progressBar, event.getIndex() + 1, event.getNumEvents(), isFinished);
		System.out.println(panel.getTitle()+" "+(1+event.getIndex())+"/"+event.getNumEvents()+" "+isFinished);
	}

}
