/**
 * 
 */
package net.sqs2.omr.swing.session;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;

import javax.swing.table.TableCellRenderer;

import net.sqs2.image.ImageFactory;
import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.model.FormAreaCommand;
import net.sqs2.omr.model.PageAreaCommand;
import net.sqs2.omr.model.PageID;
import net.sqs2.omr.model.PageTaskAccessor;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.model.SpreadSheet;
import net.sqs2.omr.result.writer.ContentsWriterUtil;
import net.sqs2.omr.session.service.MarkReaderSessionService;
import net.sqs2.omr.session.service.MarkReaderSessionServices;
import net.sqs2.omr.session.source.SessionSourceContentAccessor;
import net.sqs2.util.StringUtil;

class MarkAreasTableCellRenderer extends FormAreaTableCellRenderer implements TableCellRenderer{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public MarkAreasTableCellRenderer() {
		this.addMouseListener(new MouseListener() {

			public void mouseClicked(MouseEvent e) {
			}

			public void mouseEntered(MouseEvent e) {
				// TODO Auto-generated method stub

			}

			public void mouseExited(MouseEvent e) {
				// TODO Auto-generated method stub

			}

			public void mousePressed(MouseEvent e) {
				// TODO Auto-generated method stub

			}

			public void mouseReleased(MouseEvent e) {
				// TODO Auto-generated method stub

			}

		});
	}

	@Override
	public void paintComponent(Graphics g) {

		super.paintComponent(g);
		int compWidth = this.getWidth();
		int compHeight = this.getHeight();
		// int compHeight = this.getHeight();
		if (this.isSelected) {
			g.setColor(getBackground());
			g.fillRect(0, 0, compWidth, compHeight);
			g.setColor(getForeground());
		}

		SpreadSheet spreadSheet = this.cell.getSpreadSheet();
		SourceDirectory sourceDirectory = spreadSheet.getSourceDirectory();
		FormMaster master = (FormMaster) sourceDirectory.getPageMaster();
		int rowGroupRowIndex = this.cell.getRowGroupRowIndex();
		int columnIndex = this.cell.getColumnIndex();

		List<FormArea> formAreaList = master.getFormAreaList(columnIndex);
		int formAreaListSize = formAreaList.size();

		this.setToolTipText(StringUtil.join(formAreaList.get(0).getHints(), "\n"));

		try {
			MarkReaderSessionService session = MarkReaderSessionServices.get(spreadSheet.getSourceDirectory().getRoot());
			SessionSourceContentAccessor accessor = session.getSessionSource().getSessionSourceContentAccessor();
			PageTaskAccessor pageTaskAccessor = accessor.getPageTaskAccessor();
			List<PageAreaCommand> pageAreaCommandListParQuestion = ContentsWriterUtil
					.createPageAreaCommandListParQuestion(master, this.cell.getRowGroupSourceDirectory(),
							pageTaskAccessor, rowGroupRowIndex, columnIndex);

			List<PageID> rowGroupSourceDirectoryPageIDList = this.cell.getRowGroupSourceDirectory()
					.getPageIDList();

			int pageStart = formAreaList.get(0).getPage();
			int pageEnd = formAreaList.get(formAreaListSize - 1).getPage();

			int base = rowGroupRowIndex * master.getNumPages();

			StringBuffer path = new StringBuffer();
			if (pageStart == pageEnd) {
				String p = rowGroupSourceDirectoryPageIDList.get(pageStart + base - 1).getFileResourceID()
						.getRelativePath();
				path.append(p);
			} else {
				String p = rowGroupSourceDirectoryPageIDList.get(pageEnd + base - 1).getFileResourceID()
						.getRelativePath();
				path.append(',').append(p);
			}
			g.drawString(path.toString(), 0, 12);

			StringBuilder sb = new StringBuilder();
			for (int i = 0; i < formAreaListSize; i++) {
				// FormArea formArea = formAreaList.get(i);
				FormAreaCommand command = (FormAreaCommand) pageAreaCommandListParQuestion.get(i);
				byte[] bytes = command.getImageByteArray();
				BufferedImage image = ImageFactory.createImage(bytes, 0, command.getImageType());
				drawImage(g, 14, compWidth, i, formAreaListSize, image);
				image.flush();

				float density = command.getDensity();
				if (sb.length() == 0) {
					sb.append(" ");
				} else {
					sb.append(" | ");
				}
				sb.append(this.format.format(density * 255));
			}
			g.drawString(sb.toString(), 0, 46);

		} catch (IOException ignore) {
			ignore.printStackTrace();
		}
	}
}
