package net.sqs2.omr.swing.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

import javax.swing.JOptionPane;

import net.sqs2.omr.app.MarkReaderApp;
import net.sqs2.omr.app.service.FinishSessionService;
import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.master.PageMasterException;
import net.sqs2.omr.model.PageID;
import net.sqs2.omr.model.PageTask;
import net.sqs2.omr.model.PageTaskError;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.result.export.model.MarkAreaErrorModel;
import net.sqs2.omr.session.model.PageTaskErrorEntry;
import net.sqs2.omr.session.model.PageTaskErrorTableModel;
import net.sqs2.omr.session.model.PageTaskExecutionProgressModel;
import net.sqs2.omr.session.monitor.MarkReaderSessionMonitorAdapter;
import net.sqs2.omr.session.service.MarkReaderSessionService;
import net.sqs2.omr.swing.Images;
import net.sqs2.omr.swing.Messages;
import net.sqs2.omr.swing.session.MarkAreasTablePanel;
import net.sqs2.omr.swing.session.MarkReaderSessionPanel;
import net.sqs2.omr.swing.session.MarkReaderSessionResultBrowserController;
import net.sqs2.omr.swing.session.PageTaskErrorPanel;
import net.sqs2.omr.swing.session.RestartPromptDialog;

public class MarkReaderSessionPanelController {
	private MarkReaderApp markReaderApp;
	private final MarkReaderSessionService markReaderSession;

	private MarkReaderPanel markReaderPanel;
	private MarkReaderSessionPanel markReaderSessionPanel;
	private MarkReaderPanelController markReaderPanelController;

	private RestartPromptDialog pageTaskErrorDialog = null;

	private MarkAreasTablePanel markAreasTablePanel = null;
	private RestartPromptDialog markAreasErrorDialog = null;
	private MarkAreaErrorModel markAreaErrorModel = null;


	private int rowSerialID = 0;

	public void setMarkAreaErrorModel(MarkAreaErrorModel markAreaErrorModel){
		this.markAreaErrorModel = markAreaErrorModel;
	}
	
	public MarkReaderSessionPanelController(
			final MarkReaderApp markReaderApp,
			final MarkReaderSessionService markReaderSession,
			
			final MarkReaderPanel markReaderPanel,
			final MarkReaderPanelController markReaderPanelController,
			final MarkReaderSessionPanel markReaderSessionPanel,
			final PageTaskErrorTableModel pageTaskErrorTableModel) {
		this.markReaderApp = markReaderApp;
		this.markReaderPanel = markReaderPanel;
		this.markReaderSession = markReaderSession;
		this.markReaderSessionPanel = markReaderSessionPanel;
		this.markReaderPanelController = markReaderPanelController;

		final MarkReaderSessionResultBrowserController sessionResultController = 
			new MarkReaderSessionResultBrowserController(markReaderSession, markReaderSessionPanel.getResultBrowserPanel());
		
		markReaderSession.addSessionMonitor(new MarkReaderSessionMonitorAdapter() {

			@Override
			public void notifySessionStarted(File sourceDirectoryRootFile) {
				MarkReaderSessionPanelController.this.rowSerialID = 0;
				markReaderSessionPanel.reset();
				markReaderSession.getTaskHolder().clear();
				pageTaskErrorTableModel.getDataVector().clear();
				markReaderSession.getPageTaskExecutionProgressModel().getErrorPathToTaskErrorEntryMap().clear();
			}

			@Override
			public void notifyErrorDirectoryUnreadable(SourceDirectory sourceDirectory) {
				stopSession(markReaderSession.getSourceDirectoryRootFile());
				markReaderSessionPanel.setPauseStateGUI();
				JOptionPane.showMessageDialog(markReaderSessionPanel, Messages.SESSION_ERROR_UNREADABLE, "ERROR",
						JOptionPane.ERROR_MESSAGE);
			}

			@Override
			public void notifyErrorNumOfImages(SourceDirectory sourceDirectory, int numImages) {
				processNumErrorOfImages(sourceDirectory, numImages);
			}

			@Override
			public void notifyErrorOnPageMaster(PageMasterException ex) {
				ex.printStackTrace();
				stopSession(markReaderSession.getSourceDirectoryRootFile());
				markReaderSessionPanel.setPauseStateGUI();
				JOptionPane.showMessageDialog(markReaderSessionPanel, Messages.SESSION_ERROR_NOPDFSOURCEFOLDER+":\n"
						+ ex.getFile().getAbsolutePath(), "ERROR",
						JOptionPane.ERROR_MESSAGE);
			}

			@Override
			public void notifyStoreTask(PageTask pageTask) {
				if (pageTask.getTaskError() == null) {
					markReaderSession.getTaskHolder().incrementNumExternalizingTasks();
				} else {
					processPageTaskError(pageTask);
				}
			}

			@Override
			public void notifyErrorPageTaskReproduced(PageTask storedPageTask) {
				PageTaskError error = storedPageTask.getTaskError();
				if (error != null) {
					processPageTaskError(storedPageTask);
				}
			}

			private void processNumErrorOfImages(final SourceDirectory sourceDirectory, final int numImages) {
				markReaderSessionPanel.setPauseStateGUI();
				PageMaster master = sourceDirectory.getPageMaster();
				int numPages = master.getNumPages();
				JOptionPane.showMessageDialog(markReaderSessionPanel, Messages.SESSION_ERROR_INVALID_NUM_OF_IMAGES+"\n "
						+ sourceDirectory.getDirectory().getAbsolutePath() + "\n "+
						Messages.SESSION_ERROR_NUM_OF_IMAGES_LABEL+": " + numImages
						+ "\n "+Messages.SESSION_ERROR_NUM_OF_PAGES_LABEL+": " + numPages, "ERROR", JOptionPane.ERROR_MESSAGE);
				stopSession(sourceDirectory.getRoot());
			}

			private void processPageTaskError(PageTask pageTask) {
				addPageTaskError(pageTask);
				openPageTaskErrorDialog(pageTaskErrorTableModel);
			}

			private void openPageTaskErrorDialog(final PageTaskErrorTableModel tableModel) {

				if (MarkReaderSessionPanelController.this.pageTaskErrorDialog != null) {
					MarkReaderSessionPanelController.this.pageTaskErrorDialog.setVisible(true);
					return;
				}

				MarkReaderSessionPanelController.this.pageTaskErrorDialog = new RestartPromptDialog(
						markReaderPanel.getFrame(), Messages.PAGETASK_ERROR_DIALOG_TITLE + ":"
								+ markReaderSession.getSourceDirectoryRootFile().getAbsolutePath(),
						new PageTaskErrorPanel(tableModel), Messages.PAGETASK_ERROR_RESTART_ON_ALL_LABEL,
						Messages.PAGETASK_ERROR_RESTART_ON_UPDATED_LABEL,
						Messages.PAGETASK_ERROR_CANCEL_LABEL);
				MarkReaderSessionPanelController.this.pageTaskErrorDialog.getCancelButton().setIcon(
						Images.CANCEL_ICON);
				MarkReaderSessionPanelController.this.pageTaskErrorDialog.getCancelButton().addActionListener(
						new ActionListener() {
							public void actionPerformed(ActionEvent ev) {
								closePageTaskErrorDialog();
							}
						});

				MarkReaderSessionPanelController.this.pageTaskErrorDialog.getRestartOnAllFilesButton()
						.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent ev) {
								restartSessionByDialog(true);
							}
						});

				MarkReaderSessionPanelController.this.pageTaskErrorDialog.getRestartOnUpdatedFilesButton()
						.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent ev) {
								restartSessionByDialog(false);
							}
						});

				MarkReaderSessionPanelController.this.pageTaskErrorDialog.setVisible(true);
			}

			private void addPageTaskError(PageTask pageTask) {
				File root = markReaderSession.getPageTaskExecutionProgressModel().getSourceDirectoryRoot();
				PageID pageID = pageTask.getPageID();
				String path = pageID.getFileResourceID().getRelativePath();

				PageTaskExecutionProgressModel sessionProgressModel = markReaderSession.getPageTaskExecutionProgressModel();
				if (!sessionProgressModel.getErrorPathToTaskErrorEntryMap().containsKey(path)) {
					sessionProgressModel.getErrorPathToTaskErrorEntryMap().put(
							path,
							new PageTaskErrorEntry(MarkReaderSessionPanelController.this.rowSerialID, pageTask.getTaskError()));
					int pageNumber = pageTask.getPageNumber();
					pageTaskErrorTableModel.addRow(MarkReaderSessionPanelController.this.rowSerialID + 1,
							pageNumber, root, path, pageTask.getTaskError());
					pageTaskErrorTableModel.fireTableRowsInserted(pageTaskErrorTableModel.getRowCount() - 1,
							pageTaskErrorTableModel.getRowCount() - 1);
					pageTaskErrorTableModel.sort(0, true);
					MarkReaderSessionPanelController.this.rowSerialID++;
				}
			}

			@Override
			public synchronized void notifyExportResultDirectoryStarted(File sourceDirectoryRootFile) {
				//final MarkReaderSession session = (MarkReaderSession) MarkReaderSessions.get(sourceDirectoryRootFile);
				if (0 == markReaderSession.getPageTaskExecutionProgressModel().getNumErrorPages()) {
					sessionResultController.init();
					markReaderSessionPanel.selectExportTab();
				}
			}
			
			@Override
			public synchronized void notifyExportResultDirectoryFinished(File sourceDirectoryRootFile) {
				//openMarkAreasErrorDialog();
				new FinishSessionService().call();
			}

			@Override
			public void notifySessionFinished(File sourceDirectoryRootFile) {
				markReaderSessionPanel.setPauseStateGUI();
				markReaderPanel.setFinishedTabIcon(sourceDirectoryRootFile);
				if (0 == markReaderSessionPanel.getSessionProgressModel().getNumErrorPages()) {
					markReaderPanel.promptSessionFinished(sourceDirectoryRootFile);
					markReaderSessionPanel.selectResultTab();
				}
			}

			@Override
			public void notifySessionStopped(File sourceDirectoryRootFile) {
				markReaderSessionPanel.setPauseStateGUI();
			}
		});

		markReaderSessionPanel.setConfigButtonActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				markReaderPanelController
						.showDensityConfigurationDialog(markReaderSession.getSessionSource());
			}
		});

		markReaderSessionPanel.setCloseButtonActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				closeSession();
			}
		});

		markReaderSessionPanel.setRestartButtonActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent ev) {
				restartSession(isControlKeyDown(ev));
			}

		});

		markReaderSessionPanel.setPauseButtonActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				File sourceDirectoryRootFile = markReaderSession.getSourceDirectoryRootFile();
				stopSession(sourceDirectoryRootFile);
			}
		});

		markReaderSessionPanel.getResultBrowserPanel().getExcelButton().addActionListener(
				new ActionListener() {
					public void actionPerformed(ActionEvent ev) {
						sessionResultController.showExcel();
					}
				});

		markReaderSessionPanel.getResultBrowserPanel().getResultBrowserButton().addActionListener(
				new ActionListener() {
					public void actionPerformed(ActionEvent ev) {
						sessionResultController.openResultBrowser();
					}
				});

		markReaderSessionPanel.getResultBrowserPanel().getCsvButton().addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				sessionResultController.showCSV();
			}
		});
		markReaderSessionPanel.getResultBrowserPanel().getTextareaButton().addActionListener(
				new ActionListener() {
					public void actionPerformed(ActionEvent ev) {
						sessionResultController.showTextarea();
					}
				});

		markReaderSessionPanel.getResultBrowserPanel().getChartButton().addActionListener(
				new ActionListener() {
					public void actionPerformed(ActionEvent ev) {
						sessionResultController.showChart();
					}
				});
	}

	private void closeSession() {
		File sourceDirectoryRoot = this.markReaderSession.getSourceDirectoryRootFile();
		this.markReaderPanelController.closeSession(sourceDirectoryRoot);
		this.markReaderSession.closeSession();
	}

	private void stopSession(File sourceDirectoryRootFile) {
		this.markReaderSessionPanel.setPauseStateGUI();
		this.markReaderPanelController.stopSession(sourceDirectoryRootFile);
	}

	private boolean isControlKeyDown(final ActionEvent ev) {
		return (ev.getModifiers() & ActionEvent.CTRL_MASK) != 0;
	}

	void openMarkAreasErrorDialog() {
		if (this.markAreasErrorDialog != null) {
			this.markAreasErrorDialog.setVisible(true);
			this.markAreasTablePanel.updateTabTitle();
			return;
		}

		if (this.markAreaErrorModel.getNoAnswerMarkAreasTableModel().getRowCount() == 0
				&& this.markAreaErrorModel.getMultipleAnswersMarkAreasTableModel().getRowCount() == 0) {
			return;
		}

		this.markAreasTablePanel = 
			new MarkAreasTablePanel(this.markAreaErrorModel.getNoAnswerMarkAreasTableModel(),
				this.markAreaErrorModel.getMultipleAnswersMarkAreasTableModel());
		this.markAreasErrorDialog = new RestartPromptDialog(this.markReaderPanel.getFrame(),
				Messages.MARKAREA_ERROR_DIALOG_TITLE + ":"
						+ this.markReaderSession.getSourceDirectoryRootFile().getAbsolutePath(),
				this.markAreasTablePanel, Messages.PAGETASK_ERROR_RESTART_ON_ALL_LABEL,
				Messages.PAGETASK_ERROR_RESTART_ON_UPDATED_LABEL, Messages.PAGETASK_ERROR_CONTINUE_LABEL);

		this.markAreasErrorDialog.getCancelButton().addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				closeMarkAreaErrorsDialog();
			}
		});

		this.markAreasErrorDialog.getRestartOnAllFilesButton().addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				restartSessionByDialog(true);
			}
		});

		this.markAreasErrorDialog.getRestartOnUpdatedFilesButton().addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				restartSessionByDialog(false);
			}
		});

		this.markAreasTablePanel.updateTabTitle();
		this.markAreasErrorDialog.setVisible(true);
	}

	private void restartSession(boolean isClearMode) {
		File sourceDirectoryRootFile = this.markReaderSession.getSourceDirectoryRootFile();
		stopSession(sourceDirectoryRootFile);
		boolean isProgressTabSelected = this.markReaderSessionPanel.isProgressTabSelected();
		if (isClearMode && isProgressTabSelected) {
			try {
				markReaderApp.clearSession(sourceDirectoryRootFile);
			} catch (IOException ignore) {
				ignore.printStackTrace();
			}
		}
		this.markReaderSessionPanel.reset();
		this.markReaderSessionPanel.setPlayStateGUI();
		this.markReaderPanelController.openAndStartSession(sourceDirectoryRootFile);
	}

	private void restartSessionByDialog(boolean isClearMode) {
		File sourceDirectoryRootFile = this.markReaderSession.getSourceDirectoryRootFile();
		stopSession(sourceDirectoryRootFile);
		
		if(isClearMode){
			try{
				markReaderApp.clearSession(sourceDirectoryRootFile);
			}catch(IOException ignore){}
		}
		this.markReaderSessionPanel.setPlayStateGUI();
		this.markReaderPanelController.openAndStartSession(sourceDirectoryRootFile);
		closeMarkAreaErrorsDialog();
		closePageTaskErrorDialog();
	}

	private void closeMarkAreaErrorsDialog() {
		if(this.markAreasErrorDialog != null){
			this.markAreasErrorDialog.dispose();
			this.markAreasErrorDialog = null;
		}
	}

	private void closePageTaskErrorDialog() {
		if(this.pageTaskErrorDialog != null){
			this.pageTaskErrorDialog.dispose();
			this.pageTaskErrorDialog = null;
		}
	}
}
