package net.sqs2.omr.swing.app;

import java.awt.Window;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import net.sqs2.omr.AppConstants;
import net.sqs2.omr.MarkReaderConstants;
import net.sqs2.omr.app.MarkReaderApp;
import net.sqs2.omr.app.service.CountRemovableResultFoldersService;
import net.sqs2.omr.app.service.RemoveResultFoldersService;
import net.sqs2.omr.session.config.SourceDirectoryConfiguration;
import net.sqs2.omr.session.model.PageTaskExecutionProgressModel;
import net.sqs2.omr.session.source.SessionSource;
import net.sqs2.omr.swing.session.MarkReaderSessionPanel;
import net.sqs2.swing.FileDropTargetDecorator;
import net.sqs2.swing.process.RemoteWindowDecorator;

public class MarkReaderPanelController {

	MarkReaderApp markReaderApp;
	MarkReaderPanelImpl markReaderPanel = null;

	public MarkReaderPanelController(final MarkReaderApp markReaderApp,
			final MarkReaderPanelImpl markReaderPanel) {
		this.markReaderApp = markReaderApp;
		if (markReaderPanel == null) {
			return;
		}
		this.markReaderPanel = markReaderPanel;

		new FileDropTargetDecorator(this.markReaderPanel) {
			@Override
			public void dragEnter(DropTargetDragEvent e) {
				MarkReaderPanelController.this.dragEnter();
			}

			@Override
			public void dragOver(DropTargetDragEvent e) {
			}

			@Override
			public void dragExit(DropTargetEvent e) {
				MarkReaderPanelController.this.dragExit();
			}

			@Override
			public void drop(File sourceDirectoryRootFile) {
				markReaderPanel.setBorder(markReaderPanel.getDefaultBorder());
				openAndStartSession(sourceDirectoryRootFile);
			}
		};
	}

	public void removeResultFolders() {
		JFileChooser dchooser = this.markReaderPanel.getDirectoryChooser();
		String path = MarkReaderApp.getPreferences().get(
				AppConstants.SOURCE_DIRECTORY_ROOT_KEY_IN_PREFERENCES,
				MarkReaderConstants.DEFAULT_SOURCEDIRECTORY_PATH);
		if (path != null) {
			dchooser.setSelectedFile(new File(path));
		}
		if(showRemoveResultFolderDialog(dchooser)){
			int numRemovableResultFolders = new CountRemovableResultFoldersService(dchooser.getSelectedFile()).call();
			if(confirmRemoveResultFolders(numRemovableResultFolders)){
				new RemoveResultFoldersService(dchooser.getSelectedFile()).call();
			}
		}
	}
	
	private boolean showRemoveResultFolderDialog(JFileChooser dchooser){
		return JFileChooser.APPROVE_OPTION == dchooser.showOpenDialog(this.markReaderPanel.getFrame());
	}
	
	private boolean confirmRemoveResultFolders(int numRemovableResultFolders){
		if(0 == numRemovableResultFolders){
			JOptionPane.showMessageDialog(this.markReaderPanel.getFrame(), new Object[]{
				"no folders",
			});
			return false;
		}
		return JFileChooser.APPROVE_OPTION == 
			JOptionPane.showConfirmDialog(this.markReaderPanel.getFrame(), new Object[]{
				numRemovableResultFolders+" folders will be removed. continue?",
			});
	}


	public MarkReaderSessionPanel createSessionPanel(File sourceDirectoryRoot, PageTaskExecutionProgressModel markReaderSessionProgressModel) {
		this.markReaderPanel.getCardLayout().show(this.markReaderPanel, "tab");
		return this.markReaderPanel.createSessionPanel(sourceDirectoryRoot, markReaderSessionProgressModel);
	}

	public void showDensityConfigurationDialog(SessionSource sessionSource) {
		SourceDirectoryConfiguration config = sessionSource.getSessionSourceContentAccessor()
		.getSourceDirectory("").getConfiguration();
File configFile = new File(sessionSource.getRootDirectory().getAbsolutePath() + File.separatorChar
		+ AppConstants.getResultDirectoryName() + File.separatorChar
		+ AppConstants.SOURCE_CONFIG_FILENAME);
		MarkRecognitionConfigurationDialog dialog = new MarkRecognitionConfigurationDialog(
				this.markReaderPanel.getFrame(), configFile, config);
		dialog.pack();
		dialog.setVisible(true);
	}
	
	public void openAndStartSession(final File sourceDirectoryRootFile){
		ActionEvent ev = new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "openAndStartSession");
		new OpenAndStartSessionAction(this, markReaderApp, sourceDirectoryRootFile, this.markReaderPanel).actionPerformed(ev);
	}

	public void closeSession(final File sourceDirectoryRoot) {
		this.markReaderPanel.removeTabPanel(sourceDirectoryRoot);
		this.markReaderApp.closeSession(sourceDirectoryRoot);
	}

	public void stopSession(File sourceDirectoryRoot) {
		this.markReaderApp.stopSession(sourceDirectoryRoot);
	}

	public void promptExitConfirmation() {

		if (this.markReaderPanel.getTabbedPane().getTabCount() == 0) {
			doExit();
			return;
		}

		if (this.markReaderPanel.exitConfirmation()) {
			try {
				doExit();
			} catch (Exception ignore) {
				ignore.printStackTrace();
			}
		}
	}

	public void dragEnter() {
		this.markReaderPanel.getFrame().toFront();
		this.markReaderPanel.setBorder(this.markReaderPanel.getFocusedBorder());
	}

	public void dragExit() {
		this.markReaderPanel.setBorder(this.markReaderPanel.getDefaultBorder());
	}
	
	public void doExit() {
		Window window = RemoteWindowDecorator.inactivate(this.markReaderApp.getNetworkPeer().getRMIPort());
		window.setVisible(false);
		window.dispose();
		/*
		try {
			SQSHttpdManager.getEXIgridHttpd().stop();
		} catch (Exception ignore) {
			ignore.printStackTrace();
		}*/
		this.markReaderApp.shutdown();
		System.runFinalization();
		System.exit(0);
	}

}
