package net.sqs2.omr.session.source.impl;

import java.io.File;
import java.io.IOException;

import net.sqs2.omr.session.config.SourceDirectoryConfiguration;
import net.sqs2.omr.session.config.SourceDirectoryConfigurationFactory;
import net.sqs2.omr.session.config.SourceDirectoryConfigurations;
import net.sqs2.omr.session.source.SessionSource;
import net.sqs2.omr.session.source.SessionSourceContentAccessor;
import net.sqs2.omr.session.source.SessionSourceContentIndexer;
import net.sqs2.omr.session.source.SessionSourceState;

public class SessionSourceImpl extends AbstractSessionSourceImpl implements SessionSource{

	private SessionSourceContentAccessor sessionSourceContentAccessor;
	private SessionSourceContentIndexer sessionSourceContentIndexer;
	private SourceDirectoryConfigurations configHandlers;
	
	public SessionSourceImpl(long sessionID, File rootDirectory, SourceDirectoryConfigurationFactory sourceDirectoryConfigurationFactory) {
		super(sessionID, rootDirectory);
		this.configHandlers = new SourceDirectoryConfigurations(sourceDirectoryConfigurationFactory);
		this.sessionSourceContentIndexer = new SessionSourceContentIndexerImpl();
	}
	
	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSource#initialize()
	 */
	public void initialize() throws IOException{
		setSessionSourceState(SessionSourceState.INITIALIZING);
		this.sessionSourceContentAccessor = new SessionSourceContentAccessorImpl(getRootDirectory());
		setSessionSourceState(SessionSourceState.INITIALIZED);
	}
	
	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSource#close()
	 */
	public void close() throws IOException{
		this.sessionSourceContentAccessor.close();
		this.sessionSourceContentIndexer.close();
	}

	public void flush() throws IOException{
		this.sessionSourceContentAccessor.flush();
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSource#getConfigHandler(java.lang.String, long)
	 */
	public SourceDirectoryConfiguration getConfiguration(String path, long lastModified) throws IOException {
		return this.configHandlers.getConfigHandler(getRootDirectory(), path, lastModified);
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSource#getSessionSourceContentIndexer()
	 */
	public SessionSourceContentIndexer getSessionSourceContentIndexer() {
		return this.sessionSourceContentIndexer;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSource#getSessionSourceContentAccessor()
	 */
	public SessionSourceContentAccessor getSessionSourceContentAccessor() {
		return this.sessionSourceContentAccessor;
	}

}
