package net.sqs2.omr.session.source.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.model.PageID;
import net.sqs2.omr.model.RowID;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.session.config.SourceDirectoryConfiguration;
import net.sqs2.omr.session.source.SessionSourceContentIndexer;
import net.sqs2.omr.util.RelationList;
import net.sqs2.omr.util.RelationList.SimpleRelationList;
import net.sqs2.util.FileResourceID;
import net.sqs2.util.StringUtil;

public class SessionSourceContentIndexerImpl implements SessionSourceContentIndexer {

	public SessionSourceContentIndexerImpl() {
	}

	private RelationList<FileResourceID, PageMaster> pageMasterRegistry = new SimpleRelationList<FileResourceID, PageMaster>();
	//private RelationList<FileResourceID, SourceDirectoryConfiguration> configHandlerRegistry = new SimpleRelationList<FileResourceID, SourceDirectoryConfiguration>();
	private Map<FileResourceID, SourceDirectoryConfiguration> configHandlerRegistry = new HashMap<FileResourceID, SourceDirectoryConfiguration>();
	private RelationList<PageMaster, SourceDirectory> pageMasterSourceDirectoryRelation = new RelationList.SortedRelationList<PageMaster, SourceDirectory>();
	private Map<PageID, RowID> pageIDToRowIDMap = new HashMap<PageID, RowID>();

	private Map<PageMaster, List<SourceDirectory>> depthOrderedListMap = new HashMap<PageMaster, List<SourceDirectory>>();

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#close()
	 */
	public void close(){
		this.pageMasterRegistry.clear();
		this.configHandlerRegistry.clear();
		this.pageMasterRegistry.clear();
		this.pageIDToRowIDMap.clear();
		this.depthOrderedListMap.clear();
	}


	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#getConfigHandler(net.sqs2.util.FileResourceID)
	 */
	public SourceDirectoryConfiguration getConfigHandler(FileResourceID fileResourceID) {
		SourceDirectoryConfiguration ret = this.configHandlerRegistry.get(fileResourceID);
		if(ret == null){
			throw new IllegalArgumentException(fileResourceID.toString());
		}else{
			return ret;
		}
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#setConfigHandler(net.sqs2.util.FileResourceID, net.sqs2.omr.session.config.SourceDirectoryConfiguration)
	 */
	public void setConfiguration(FileResourceID fileResourceID, SourceDirectoryConfiguration configHandler) {
		this.configHandlerRegistry.put(fileResourceID, configHandler);
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#addSourceDirectory(net.sqs2.omr.master.PageMaster, net.sqs2.omr.page.source.SourceDirectory)
	 */
	public void addSourceDirectory(PageMaster pageMaster, SourceDirectory sourceDirectory) {
		this.pageMasterSourceDirectoryRelation.put(pageMaster, sourceDirectory);
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#getSourceDirectoryList(net.sqs2.omr.master.PageMaster)
	 */
	public List<SourceDirectory> getSourceDirectoryList(PageMaster pageMaster) {
		return this.pageMasterSourceDirectoryRelation.getValueListB(pageMaster);
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#putPageMaster(net.sqs2.util.FileResourceID, net.sqs2.omr.master.PageMaster)
	 */
	public void putPageMaster(FileResourceID fileResourceID, PageMaster master) {
		if (!this.pageMasterRegistry.containsKey(fileResourceID)) {
			this.pageMasterRegistry.put(fileResourceID, master);
		}
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#getPageMasterList()
	 */
	public List<PageMaster> getPageMasterList() {
		return this.pageMasterRegistry.getUniqueValueList();
	}

	/*
	 * public Set<PageMaster> getPageMasterSet(){ return
	 * this.pageMasterRegistry.getValueSet(); }
	 */

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#getPageMaster(net.sqs2.util.FileResourceID)
	 */
	public PageMaster getPageMaster(FileResourceID fileResourceID) {
		return this.pageMasterRegistry.getFirstValue(fileResourceID);
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#putRowID(net.sqs2.omr.page.source.PageID, net.sqs2.omr.model.RowID)
	 */
	public void putRowID(PageID pageID, RowID rowID) {
		this.pageIDToRowIDMap.put(pageID, rowID);
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#removeRowID(net.sqs2.omr.page.source.PageID)
	 */
	public void removeRowID(PageID pageID) {
		this.pageIDToRowIDMap.remove(pageID);
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#getRowID(net.sqs2.omr.page.source.PageID)
	 */
	public RowID getRowID(PageID pageID) {
		return this.pageIDToRowIDMap.get(pageID);
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#getSourceDirectoryDepthOrderedListMap()
	 */
	public Map<PageMaster, List<SourceDirectory>> getSourceDirectoryDepthOrderedListMap() {
		return this.depthOrderedListMap;
	}
	
	public Map<PageMaster, List<SourceDirectory>> createSourceDirectoryDepthOrderedListMap() {
		return this.depthOrderedListMap = new SpreadSheetListMapFactory().create();
	}

	class SpreadSheetListMapFactory {

		public Map<PageMaster, List<SourceDirectory>> create() {
			Map<PageMaster, List<SourceDirectory>> sourceDirectoryListList = new HashMap<PageMaster, List<SourceDirectory>>();
			for (PageMaster master : SessionSourceContentIndexerImpl.this.pageMasterRegistry.getKeySetB()) {
				ArrayList<SourceDirectory> flattenSourceDirectoryList = new ArrayList<SourceDirectory>();
				createTableGroupListByMaster(master, flattenSourceDirectoryList);
				sourceDirectoryListList.put(master, flattenSourceDirectoryList);
			}
			return sourceDirectoryListList;
		}

		private void createTableGroupListByMaster(PageMaster master, ArrayList<SourceDirectory> flattenSourceDirectoryList) {
			int maxDepth = -1;
			Map<Integer, List<SourceDirectory>> map = new HashMap<Integer, List<SourceDirectory>>();
			for (SourceDirectory sourceDirectory : getSourceDirectoryList(master)) {
				int depth = (sourceDirectory.getPath().equals("")) ? 1 : StringUtil.split(
						sourceDirectory.getPath(), File.separatorChar).size() + 1;
				maxDepth = Math.max(depth, maxDepth);
				List<SourceDirectory> list = map.get(depth);
				if (list == null) {
					list = new ArrayList<SourceDirectory>();
					map.put(depth, list);
				}
				list.add(sourceDirectory);
			}
			createTableGroupListByMaster(map, maxDepth, flattenSourceDirectoryList);
		}

		private void createTableGroupListByMaster(Map<Integer, List<SourceDirectory>> map, int maxDepth, List<SourceDirectory> flattenSourceDirectoryList) {
			int indexBase = 0;
			for (int i = 0; i <= maxDepth; i++) {
				List<SourceDirectory> sourceDirectoryList = map.get(i);
				if (sourceDirectoryList != null) {
					for (SourceDirectory sourceDirectory : sourceDirectoryList) {
						flattenSourceDirectoryList.add(sourceDirectory);
					}
					indexBase += sourceDirectoryList.size();
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.SessionSourceContentIndexer#getSourceDirectoryList(net.sqs2.omr.master.FormMaster)
	 */
	public List<SourceDirectory> getSourceDirectoryList(FormMaster master) {
		return this.pageMasterSourceDirectoryRelation.getValueListB(master);
	}

	@Override
	public int getNumSourceDirectories(PageMaster pageMaster) {
		return pageMasterSourceDirectoryRelation.getValueListB(pageMaster).size();
	}

	@Override
	public SourceDirectory getSourceDirectory(PageMaster pageMaster, int tableIndex) {
		return pageMasterSourceDirectoryRelation.getValueListB(pageMaster).get(tableIndex);
	}
}
