package net.sqs2.omr.session.source.impl;

import java.io.File;

import net.sqs2.omr.session.source.AbstractSessionSource;
import net.sqs2.omr.session.source.SessionSourceState;

public class AbstractSessionSourceImpl implements AbstractSessionSource {
	private long sessionID;
	private File rootDirectory;
	private SessionSourceState sessionSourceState;

	public AbstractSessionSourceImpl(long sessionID, File rootDirectory){
		this.sessionID = sessionID;
		this.rootDirectory = rootDirectory;
		this.sessionSourceState = SessionSourceState.NOT_INITIALIZED;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#getSessionID()
	 */
	public long getSessionID() {
		return this.sessionID;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#getRootDirectory()
	 */
	public File getRootDirectory() {
		return this.rootDirectory;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#getSessionSourceState()
	 */
	public SessionSourceState getSessionSourceState() {
		return this.sessionSourceState;
	}
	
	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#setSessionSourceState(net.sqs2.omr.session.source.SessionSourceState)
	 */
	public void setSessionSourceState(SessionSourceState sessionSourceState){
		this.sessionSourceState = sessionSourceState;	
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#hasStarted()
	 */
	public boolean hasStarted() {
		return this.sessionSourceState != SessionSourceState.NOT_INITIALIZED;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#isInitialized()
	 */
	public boolean isInitialized() {
		return this.sessionSourceState == SessionSourceState.INITIALIZED;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#setPreparing()
	 */
	public void setPreparing() {
		if (this.sessionSourceState != SessionSourceState.INITIALIZED) {
			throw new RuntimeException("SessionSourceState NOT INITIALIZED");
		}
		this.sessionSourceState = SessionSourceState.PREPARING;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#isPreparing()
	 */
	public boolean isPreparing() {
		return this.sessionSourceState == SessionSourceState.PREPARING;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#setPrepared()
	 */
	public void setPrepared() {
		if (this.sessionSourceState != SessionSourceState.PREPARING) {
			throw new RuntimeException("SessionSourceState NOT RUNNGING");
		}
		this.sessionSourceState = SessionSourceState.PREPARED;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#isPrepared()
	 */
	public boolean isPrepared() {
		return this.sessionSourceState == SessionSourceState.PREPARED;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#setStopped()
	 */
	public void setStopped() {
		this.sessionSourceState = SessionSourceState.STOPPED;
	}
	
	public boolean isFinished() {
		return this.sessionSourceState == SessionSourceState.FINISHED;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#setFinished()
	 */
	public void setFinished() {
		if (this.sessionSourceState != SessionSourceState.PREPARED) {
			throw new RuntimeException("SessionSourceState NOT PREPARED");
		}
		this.sessionSourceState = SessionSourceState.FINISHED;
	}

	/* (non-Javadoc)
	 * @see net.sqs2.omr.session.source.IA#hasStopped()
	 */
	public boolean hasStopped() {
		return this.sessionSourceState == SessionSourceState.STOPPED;
	}

}
