package net.sqs2.omr.session.source;

import java.util.List;

import org.apache.commons.collections15.map.ListOrderedMap;

public class SessionSources {
	private static ListOrderedMap<Long, SessionSource> sessionIDToSessionSourceMap = new ListOrderedMap<Long, SessionSource>();

	public static SessionSource get(long sessionID) {
		SessionSource sessionSource = sessionIDToSessionSourceMap.get(sessionID);
		return sessionSource;
	}
	
	public static List<Long> getSessionIDList(){
		return sessionIDToSessionSourceMap.asList();
	}

	public static void add(SessionSource sessionSource) {
		sessionIDToSessionSourceMap.put(sessionSource.getSessionID(), sessionSource);
	}

	public static void remove(long sessionID) {
		sessionIDToSessionSourceMap.remove(sessionID);
	}

}
