package net.sqs2.omr.session.source;

import java.rmi.Remote;
import java.rmi.RemoteException;

import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.model.PageTask;
import net.sqs2.omr.session.config.SourceDirectoryConfiguration;
import net.sqs2.omr.util.FileResource;
import net.sqs2.util.FileResourceID;

public interface SessionSourceServer extends Remote{

	public boolean existsRunningLocalSessions()throws RemoteException;
	
	public long ping(long key) throws RemoteException;

	public PageTask leaseTask(long key) throws RemoteException;

	public PageMaster getMaster(long key, long sessionID, FileResourceID fileResourceID) throws RemoteException;

	public SourceDirectoryConfiguration getConfigration(long key, long sessionID, FileResourceID fileResourceID) throws RemoteException;

	public FileResource getFileResource(long key, long sessionID, FileResourceID fileResourceID) throws RemoteException;

	public void submitPageTask(long key, long sessionID, PageTask pageTask) throws RemoteException;
}
