package net.sqs2.omr.session.source;

import java.util.List;
import java.util.Map;

import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.model.PageID;
import net.sqs2.omr.model.RowID;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.session.config.SourceDirectoryConfiguration;
import net.sqs2.util.FileResourceID;

public interface SessionSourceContentIndexer {

	public abstract void close();

	public abstract SourceDirectoryConfiguration getConfigHandler(
			FileResourceID fileResourceID);

	public abstract void setConfiguration(FileResourceID fileResourceID,
			SourceDirectoryConfiguration configHandler);

	public abstract void addSourceDirectory(PageMaster pageMaster,
			SourceDirectory sourceDirectory);

	public abstract int getNumSourceDirectories(PageMaster pageMaster);
	
	public abstract SourceDirectory getSourceDirectory(PageMaster pageMaster, int tableIndex);

	public abstract void putPageMaster(FileResourceID fileResourceID,
			PageMaster master);

	public abstract List<PageMaster> getPageMasterList();

	public abstract PageMaster getPageMaster(FileResourceID fileResourceID);

	public abstract void putRowID(PageID pageID, RowID rowID);

	public abstract void removeRowID(PageID pageID);

	public abstract RowID getRowID(PageID pageID);

	public abstract Map<PageMaster, List<SourceDirectory>> createSourceDirectoryDepthOrderedListMap();
	
	public abstract Map<PageMaster, List<SourceDirectory>> getSourceDirectoryDepthOrderedListMap();

	public abstract List<SourceDirectory> getSourceDirectoryList(
			FormMaster master);

}