package net.sqs2.omr.session.source;

import java.io.File;
import java.io.IOException;

import net.sqs2.omr.master.PageMasterAccessor;
import net.sqs2.omr.model.PageTaskAccessor;
import net.sqs2.omr.model.RowAccessor;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.util.FileContentCache;

public interface SessionSourceContentAccessor {

	public abstract void close() throws IOException;
	
	public abstract void flush() throws IOException;

	public abstract PageMasterAccessor getPageMasterAccessor();

	public abstract PageTaskAccessor getPageTaskAccessor();

	public abstract RowAccessor getRowAccessor();

	public abstract FileContentCache getFileContentCache();

	public abstract File getRootDirectory();

	public abstract void putSourceDirectory(String path,
			SourceDirectory sourceDirectory);

	public abstract SourceDirectory getSourceDirectory(String path);
	
}