package net.sqs2.omr.session.source;

import java.io.IOException;

import net.sqs2.omr.session.config.SourceDirectoryConfiguration;

public interface SessionSource extends AbstractSessionSource{
	
	public abstract void initialize() throws IOException;

	public abstract void flush() throws IOException;
	
	public abstract void close() throws IOException;

	public abstract SourceDirectoryConfiguration getConfiguration(String path, long lastModified) throws IOException;

	public abstract SessionSourceContentIndexer getSessionSourceContentIndexer();
	public abstract SessionSourceContentAccessor getSessionSourceContentAccessor();

}