/**
 * 
 */
package net.sqs2.omr.session.service;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;

import net.sqs2.omr.app.config.MarkReaderAppConfiguration;
import net.sqs2.omr.master.FormMasterFactory;
import net.sqs2.omr.master.PageMasterException;
import net.sqs2.omr.model.PageTaskException;
import net.sqs2.omr.session.config.SourceDirectoryConfigurationFactoryImpl;
import net.sqs2.omr.session.monitor.SourceInitializationMonitor;
import net.sqs2.omr.session.source.SessionSource;
import net.sqs2.omr.session.source.SessionSourceException;
import net.sqs2.omr.session.source.SessionSourceInitializer;
import net.sqs2.omr.session.source.SessionSources;
import net.sqs2.omr.session.source.SessionStopException;
import net.sqs2.omr.session.source.SourceInitializationStopException;
import net.sqs2.omr.session.source.impl.SessionSourceImpl;

class SessionSourceFactoryService implements Callable<SessionSource>{
	SessionSource sessionSource;
	SessionSourceInitializer sessionSourceInitializer;
	SessionSourceFactoryService(long sessionID, File sourceDirectoryRootFile, FormMasterFactory formMasterFactory,
			SourceInitializationMonitor monitor)
			throws IOException, PageTaskException, SessionSourceException, PageMasterException, SessionStopException {
			
		this.sessionSource = new SessionSourceImpl(sessionID, sourceDirectoryRootFile,
				new SourceDirectoryConfigurationFactoryImpl());
		this.sessionSourceInitializer = new SessionSourceInitializer(formMasterFactory,
				this.sessionSource, monitor,
				MarkReaderAppConfiguration.isSearchPageMasterFromAncestorDirectory);
	}
	
	public SessionSource call()throws SessionSourceException, PageMasterException, SourceInitializationStopException, SessionStopException, IOException{
		if(this.sessionSourceInitializer == null){
			throw new RuntimeException("SessionSourceFactory cannot reused.");
		}
		this.sessionSourceInitializer.call();		
		SessionSources.add(this.sessionSource);
		this.sessionSourceInitializer = null;		
		return this.sessionSource;
	}
}