/**
 * 
 */
package net.sqs2.omr.session.service;

import java.io.IOException;

import net.sqs2.omr.AppConstants;
import net.sqs2.omr.app.config.MarkReaderAppConfiguration;
import net.sqs2.omr.result.export.SessionResultExportModule;
import net.sqs2.omr.result.export.chart.ChartExportModule;
import net.sqs2.omr.result.export.html.HTMLReportExportModule;
import net.sqs2.omr.result.export.spreadsheet.CSVExportModule;
import net.sqs2.omr.result.export.spreadsheet.ExcelExportModule;
import net.sqs2.omr.result.export.textarea.TextAreaExportModule;
import net.sqs2.omr.result.walker.ResultWalker;
import net.sqs2.omr.session.source.SessionSource;

class ResultWalkerFactoryService{
	ResultWalker createResultWalker(boolean isGUIMode, SessionSource sessionSource)throws IOException{
		ResultWalker sessionResultWalker = new ResultWalker(sessionSource);
		//sessionResultWalker.addEventConsumer(new DummyExportModule());
		
		if (! isGUIMode || MarkReaderAppConfiguration.isExportSpreadSheetEnabled) {
			sessionResultWalker.addEventConsumer(new CSVExportModule());
			sessionResultWalker.addEventConsumer(new ExcelExportModule());
		}
		if (! isGUIMode || MarkReaderAppConfiguration.isExportTextAreaImageEnabled
				|| MarkReaderAppConfiguration.isExportChartImageEnabled) {
			HTMLReportExportModule htmlExporterModule = new HTMLReportExportModule(AppConstants.SKIN_ID);
			sessionResultWalker.addEventConsumer(htmlExporterModule);
			
			if (! isGUIMode || MarkReaderAppConfiguration.isExportChartImageEnabled()) {
				SessionResultExportModule sessionResultExportModule = new SessionResultExportModule();
				sessionResultWalker.addEventConsumer(sessionResultExportModule);
				ChartExportModule chartExportModule = new ChartExportModule(sessionResultExportModule, AppConstants.SKIN_ID);
				sessionResultWalker.addEventConsumer(chartExportModule);
			}
			if (! isGUIMode || MarkReaderAppConfiguration.isExportTextAreaImageEnabled()) {
				TextAreaExportModule textAreaExportModule = new TextAreaExportModule(AppConstants.SKIN_ID);			
				sessionResultWalker.addEventConsumer(textAreaExportModule);
			}
		}
		return sessionResultWalker;
	}
	
}