/*

 MarkReaderSessions.java

 Copyright 2009 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */

package net.sqs2.omr.session.service;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import net.sqs2.omr.master.FormMasterFactory;
import net.sqs2.omr.session.broker.impl.PageTaskExecutorSessionServerDispatcher;
import net.sqs2.omr.session.broker.impl.RemotePageTaskExecutorPeer;

import org.apache.commons.collections15.Bag;
import org.apache.commons.collections15.bag.HashBag;

public class MarkReaderSessionServices{

	private static Map<Long, MarkReaderSessionService> sessionIDToSessionMap = new HashMap<Long, MarkReaderSessionService>();
	private static Map<File, MarkReaderSessionService> sourceDirectoryRootToSessionMap = new HashMap<File, MarkReaderSessionService>();
	private static Bag<File> sessionNameBag = new HashBag<File>();

	public static synchronized MarkReaderSessionService create(File sourceDirectoryRoot, RemotePageTaskExecutorPeer peer, 
			FormMasterFactory formMasterFactory, PageTaskExecutorSessionServerDispatcher localTaskExecutorEnv) throws IOException{
		MarkReaderSessionService session = new MarkReaderSessionServiceImpl(sourceDirectoryRoot, peer, formMasterFactory, localTaskExecutorEnv);
		sessionNameBag.add(sourceDirectoryRoot);
		sourceDirectoryRootToSessionMap.put(sourceDirectoryRoot, session);
		MarkReaderSessionServices.add(session);
		return session;
	}

	public static MarkReaderSessionService get(long sessionID) {
		return sessionIDToSessionMap.get(sessionID);
	}

	public static Collection<MarkReaderSessionService> getSessions() {
		return sessionIDToSessionMap.values();
	}

	public static void add(MarkReaderSessionService session) {
		sessionIDToSessionMap.put(session.getSessionID(), session);
	}

	private static void remove(long sessionID) {
		sessionIDToSessionMap.remove(sessionID);
	}
	public static synchronized int countSessionsBySourceDirectory(File sourceDirectoryRootFile) {
		int numSameNameSessions = sessionNameBag.getCount(sourceDirectoryRootFile);
		return numSameNameSessions;
	}

	public static synchronized boolean contains(File sourceDirectoryRoot) {
		return sourceDirectoryRootToSessionMap.containsKey(sourceDirectoryRoot);
	}

	/**
	 * @param sourceDirectoryRoot
	 * @return null when there is no session you have specified.
	 */
	public static synchronized MarkReaderSessionService get(File sourceDirectoryRoot) {
		MarkReaderSessionService session = sourceDirectoryRootToSessionMap.get(sourceDirectoryRoot);
		return session;
	}

	public static synchronized void remove(File sourceDirectoryRoot) {
		MarkReaderSessionService session = sourceDirectoryRootToSessionMap.remove(sourceDirectoryRoot);
		if (session == null) {
			throw new RuntimeException("no such session:" + sourceDirectoryRoot.getAbsolutePath());
		}
		sessionNameBag.remove(sourceDirectoryRoot);
		MarkReaderSessionServices.remove(session.getSessionID());
	}

}
