package net.sqs2.omr.session.service;

import java.io.File;
import java.io.IOException;

import net.sqs2.omr.model.PageTask;
import net.sqs2.omr.model.PageTaskHolder;
import net.sqs2.omr.result.export.model.MarkAreaErrorModel;
import net.sqs2.omr.result.walker.ResultWalker;
import net.sqs2.omr.session.model.PageTaskExecutionProgressModel;
import net.sqs2.omr.session.monitor.MarkReaderSessionMonitor;
import net.sqs2.omr.session.source.SessionSource;

public interface MarkReaderSessionService {
	public long getSessionID();
	public void setGUIMode(boolean isGUIMode);
	public void addSessionMonitor(MarkReaderSessionMonitor monitor);
	public void removeSessionMonitor(MarkReaderSessionMonitor monitor);
	public PageTaskHolder getTaskHolder();
	public SessionSource getSessionSource();
	public void notifyStoreTask(PageTask pageTask);
	public boolean isInactive();
	public boolean hasStarted();
	public boolean hasStopped();
	public boolean isRunning();
	public void startSession() throws IOException;
	public void stopSession();
	public void finishSession();
	public void closeSession();
	public File getSourceDirectoryRootFile();
	public void setMarkAreaErrorModel(MarkAreaErrorModel markAreaErrorModel);
	public MarkAreaErrorModel getMarkAreaErrorModel();
	public PageTaskExecutionProgressModel getPageTaskExecutionProgressModel();
	public ResultWalker getSessionResultExporter();
	
}