/*

 MarkReaderSessionMonitors.java

 Copyright 2009 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */
package net.sqs2.omr.session.monitor;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.master.PageMasterException;
import net.sqs2.omr.model.PageTask;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.session.config.SourceDirectoryConfiguration;
import edu.emory.mathcs.backport.java.util.Collections;

public class MarkReaderSessionMonitorImpl implements SourceInitializationMonitor{
	protected Set<MarkReaderSessionMonitor> monitors;
	@SuppressWarnings("unchecked")
	public MarkReaderSessionMonitorImpl(){
		this.monitors = Collections.synchronizedSet(new HashSet<MarkReaderSessionMonitor>(1));
	}
	
	public synchronized void addSessionMonitor(MarkReaderSessionMonitor monitor) {
		this.monitors.add(monitor);
	}

	public synchronized void removeSessionMonitor(MarkReaderSessionMonitor monitor) {
		this.monitors.remove(monitor);
	}

	public synchronized void deleteSessionMonitors() {
		this.monitors.clear();
	}

	public synchronized void notifySessionStarted(File sourceDirectoryRootFile) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifySessionStarted(sourceDirectoryRootFile);
		}
	}

	public synchronized void notifySessionStopped(File sourceDirectoryRootFile) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifySessionStopped(sourceDirectoryRootFile);
		}
	}

	public synchronized void notifyExportResultDirectoryStarted(File sourceDirectoryRootFile) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyExportResultDirectoryStarted(sourceDirectoryRootFile);
		}
	}

	public synchronized void notifyExportResultDirectoryFinished(File sourceDirectoryRootFile) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyExportResultDirectoryFinished(sourceDirectoryRootFile);
		}
	}

	public synchronized void notifySessionResult(File sourceDirectoryRootFile) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifySessionResult(sourceDirectoryRootFile);
		}
	}

	public synchronized void notifySessionFinished(File sourceDirectoryRootFile) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifySessionFinished(sourceDirectoryRootFile);
		}
	}

	public synchronized void notifyPageTaskProduced(PageTask pageTask) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyPageTaskProduced(pageTask);
		}
	}

	public synchronized void notifyErrorPageTaskReproduced(PageTask storedTask) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyErrorPageTaskReproduced(storedTask);
		}
	}

	public synchronized void notifyStoreTask(PageTask pageTask) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyStoreTask(pageTask);
		}
	}

	public synchronized void notifyFoundMaster(PageMaster master) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyFoundMaster(master);
		}
	}

	public synchronized void notifyFoundConfig(SourceDirectoryConfiguration config) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyFoundConfig(config);
		}
	}

	public synchronized void notifyFoundImages(int numAddedImages, File sourceDirectory) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyFoundImages(numAddedImages, sourceDirectory);
		}
	}

	public synchronized void notifyScanDirectory(File subSourceDirectory) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyScanDirectory(subSourceDirectory);
		}
	}

	public synchronized void notifySourceInitializeDone(File sourceDirectoryRootFile) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifySourceInitializeDone(sourceDirectoryRootFile);
		}
	}

	public void notifyErrorDirectoryUnreadable(SourceDirectory sourceDirectory) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyErrorDirectoryUnreadable(sourceDirectory);
		}
	}

	public synchronized void notifyErrorNumOfImages(SourceDirectory sourceDirectory, int numImages) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyErrorNumOfImages(sourceDirectory, numImages);
		}
	}

	public void notifyErrorOnPageMaster(PageMasterException ex) {
		for (MarkReaderSessionMonitor monitor : this.monitors) {
			monitor.notifyErrorOnPageMaster(ex);
		}
	}
	

}