package net.sqs2.omr.session.consumer;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;

import net.sqs2.omr.model.PageTask;
import net.sqs2.omr.session.service.MarkReaderSessionService;
import net.sqs2.omr.session.source.SessionSource;

public abstract class AbstractPageTaskConsumer implements PageTaskConsumer, Callable<Void> {

	protected MarkReaderSessionService session;

	public AbstractPageTaskConsumer(MarkReaderSessionService session) throws IOException {
		this.session = session;
	}

	public Void call() throws IOException {
		while (true) {
			PageTask task = this.session.getTaskHolder().pollSubmittedTask();
			if (task != null) {
				storeTask(task);
				this.session.notifyStoreTask(task);
			} else if (this.canFinish()) {
				break;
			} else {
				// no submitted task, still remains leased tasks, wait 1
				// sec.
				try {
					Thread.sleep(1000);
				} catch (InterruptedException ignore) {
				}
			}
		}
		return null;
	}

	public boolean canFinish() throws IOException {
		SessionSource sessionSource = this.session.getSessionSource();
		boolean isPrepared = sessionSource.isPrepared();
		boolean isEmpty = this.session.getTaskHolder().isEmpty();
		if (isPrepared && isEmpty) {
			return true;
		}
		return false;
	}

	void storeTask(PageTask task) {
		try {
			consumeTask(task);
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}

	abstract public void consumeTask(PageTask task) throws RemoteException;
}
